/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.economy;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.economy.Economy;
import fr.maxlego08.essentials.api.economy.EconomyManager;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.command.CommandSender;

public abstract class GiveCommand
extends VCommand {
    public GiveCommand(EssentialsPlugin plugin) {
        super(plugin);
    }

    protected CommandResultType give(CommandSender sender, String userName, String economyName, double amount, boolean silent, String reason) {
        EconomyManager economyManager = this.plugin.getEconomyManager();
        Optional<Economy> optional = economyManager.getEconomy(economyName);
        if (optional.isEmpty()) {
            this.message(sender, Message.COMMAND_ECONOMY_NOT_FOUND, "%name%", economyName);
            return CommandResultType.DEFAULT;
        }
        Economy economy = optional.get();
        this.fetchUniqueId(userName, uniqueId -> {
            economyManager.deposit((UUID)uniqueId, economy, new BigDecimal(amount), reason);
            String economyFormat = economyManager.format(economy, (Number)amount);
            this.message(sender, Message.COMMAND_ECONOMY_GIVE_SENDER, "%player%", userName, "%economyFormat%", economyFormat);
            if (!silent) {
                this.message((UUID)uniqueId, Message.COMMAND_ECONOMY_GIVE_RECEIVER, (Object)"%economyFormat%", (Object)economyFormat);
            }
        });
        return CommandResultType.SUCCESS;
    }
}

