/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.essentials;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.waypoint.WayPointHelper;
import fr.maxlego08.essentials.api.waypoint.WayPointIcon;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import java.awt.Color;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;

public class CommandEssentialsTestWayPoint
extends VCommand {
    public CommandEssentialsTestWayPoint(EssentialsPlugin plugin) {
        super(plugin);
        this.addSubCommand("test-waypoint");
        this.setPermission(Permission.ESSENTIALS_RELOAD);
        this.setDescription(Message.DESCRIPTION_RELOAD);
        this.onlyPlayers();
        this.addRequireArg("method", (a, b) -> List.of("create", "update", "remove"));
        this.addRequireArg("uuid", (a, b) -> List.of(UUID.randomUUID().toString()));
        this.addRequireArg("x");
        this.addRequireArg("y");
        this.addRequireArg("z");
        this.addRequireArg("color");
        this.addOptionalArg("texture");
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        String method = this.argAsString(0);
        UUID uuid = UUID.fromString(this.argAsString(1));
        int x = this.argAsInteger(2);
        int y = this.argAsInteger(3);
        int z = this.argAsInteger(4);
        int color = this.argAsInteger(5);
        String texture = this.argAsString(6, null);
        Location location = new Location(this.player.getWorld(), (double)x, (double)y, (double)z);
        WayPointHelper helper = plugin.getWayPointHelper();
        if (method.equals("create")) {
            helper.addWayPoint(this.player, uuid, location, WayPointIcon.of(texture, new Color(color)));
            this.message(this.sender, "&fWayPoint created!");
        } else if (method.equals("update")) {
            helper.updateWayPointPosition(this.player, uuid, location, WayPointIcon.of(texture, new Color(color)));
            this.message(this.sender, "&fWayPoint updated!");
        } else if (method.equals("remove")) {
            helper.removeWayPoint(this.player, uuid);
            this.message(this.sender, "&fWayPoint deleted!");
        } else {
            return CommandResultType.SYNTAX_ERROR;
        }
        return CommandResultType.SUCCESS;
    }
}

