/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.home;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.home.Home;
import fr.maxlego08.essentials.api.home.HomeManager;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.module.modules.HomeModule;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import java.util.ArrayList;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class CommandDelHome
extends VCommand {
    public CommandDelHome(EssentialsPlugin plugin) {
        super(plugin);
        this.setModule(HomeModule.class);
        this.setPermission(Permission.ESSENTIALS_DEL_HOME);
        this.setDescription(Message.DESCRIPTION_DEL_HOME);
        this.addRequireArg("name", (sender, args) -> {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                User user = plugin.getUser(player.getUniqueId());
                return user.getHomes().stream().map(Home::getName).toList();
            }
            return new ArrayList();
        });
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        String homeName = this.argAsString(0);
        HomeManager homeManager = plugin.getHomeManager();
        if (homeName.contains(":") && this.hasPermission((Permissible)this.sender, Permission.ESSENTIALS_SET_HOME_OTHER)) {
            String[] values = homeName.split(":", 2);
            String username = values[0];
            String home = values[1];
            homeManager.deleteHome(this.sender, username, home);
            return CommandResultType.DEFAULT;
        }
        if (homeManager.isHomeDeleteConfirm()) {
            this.message(this.user, Message.COMMAND_HOME_DELETE_CONFIRM, "%name%", homeName);
            return CommandResultType.SUCCESS;
        }
        homeManager.deleteHome(this.player, this.user, homeName);
        return CommandResultType.SUCCESS;
    }
}

