/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.home;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.home.Home;
import fr.maxlego08.essentials.api.home.HomeManager;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.module.modules.HomeModule;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import java.util.ArrayList;
import java.util.Optional;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class CommandHome
extends VCommand {
    public CommandHome(EssentialsPlugin plugin) {
        super(plugin);
        this.setModule(HomeModule.class);
        this.setPermission(Permission.ESSENTIALS_HOME);
        this.setDescription(Message.DESCRIPTION_HOME);
        this.addOptionalArg("name", (sender, args) -> {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                User user = plugin.getUser(player.getUniqueId());
                return user.getHomes().stream().map(Home::getName).toList();
            }
            return new ArrayList();
        });
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        String homeName = this.argAsString(0, null);
        HomeManager homeManager = plugin.getHomeManager();
        if (homeName == null) {
            if (this.sender instanceof ConsoleCommandSender) {
                return CommandResultType.SYNTAX_ERROR;
            }
            homeManager.sendHomes(this.player, this.user);
            return CommandResultType.SUCCESS;
        }
        if (homeName.contains(":") && this.hasPermission((Permissible)this.sender, Permission.ESSENTIALS_HOME_OTHER)) {
            if (this.sender instanceof ConsoleCommandSender) {
                return CommandResultType.SYNTAX_ERROR;
            }
            String[] values = homeName.split(":", 2);
            String username = values[0];
            String home = values[1];
            homeManager.teleport(this.user, username, home);
            return CommandResultType.DEFAULT;
        }
        Optional<Home> optional = this.user.getHome(homeName);
        if (optional.isEmpty()) {
            this.message(this.sender, Message.COMMAND_HOME_DOESNT_EXIST, "%name%", homeName);
            return CommandResultType.DEFAULT;
        }
        Home home = optional.get();
        homeManager.teleport(this.user, home);
        return CommandResultType.SUCCESS;
    }
}

