/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.home;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.home.HomeManager;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.module.modules.HomeModule;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import org.bukkit.permissions.Permissible;

public class CommandSetHomeConfirm
extends VCommand {
    public CommandSetHomeConfirm(EssentialsPlugin plugin) {
        super(plugin);
        this.setModule(HomeModule.class);
        this.setPermission(Permission.ESSENTIALS_SET_HOME_CONFIRM);
        this.setDescription(Message.DESCRIPTION_SET_HOME_CONFIRM);
        this.addRequireArg("name");
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        String homeName = this.argAsString(0);
        HomeManager homeManager = plugin.getHomeManager();
        if (homeManager.getDisableWorlds().contains(this.player.getWorld().getName())) {
            this.message(this.sender, Message.COMMAND_SET_HOME_WORLD, new Object[0]);
            return CommandResultType.DEFAULT;
        }
        Message nameResult = homeManager.isValidHomeName(homeName);
        if (nameResult != null) {
            this.message(this.sender, nameResult, "%name%", homeName);
            return CommandResultType.DEFAULT;
        }
        int maxHome = plugin.getMaxHome((Permissible)this.player);
        int current = this.user.countHomes();
        if (current >= maxHome && !this.user.isHomeName(homeName)) {
            this.message(this.sender, Message.COMMAND_SET_HOME_MAX, "%name%", homeName, "%max%", maxHome, "%current%", current);
            return CommandResultType.DEFAULT;
        }
        this.user.setHome(homeName, this.player.getLocation(), true);
        this.message(this.sender, Message.COMMAND_SET_HOME_CREATE, "%name%", homeName, "%max%", maxHome, "%current%", this.user.countHomes());
        return CommandResultType.SUCCESS;
    }
}

