/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.utils;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.utils.TransformMaterial;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class CommandCompactAll
extends VCommand {
    public CommandCompactAll(EssentialsPlugin plugin) {
        super(plugin);
        this.setPermission(Permission.ESSENTIALS_COMPACT_ALL);
        this.setDescription(Message.DESCRIPTION_COMPACT_ALL);
        this.onlyPlayers();
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        List<TransformMaterial> compactMaterials = this.configuration.getCompactMaterials();
        compactMaterials.forEach(compactMaterial -> {
            Material newMaterial = compactMaterial.to();
            Material material = compactMaterial.from();
            PlayerInventory inventory = this.player.getInventory();
            int amountOf = this.count((Inventory)inventory, material);
            if (amountOf < 9) {
                return;
            }
            int realAmount = amountOf / 9;
            this.removeItems((Inventory)inventory, new ItemStack(material), realAmount * 9);
            this.plugin.give(this.player, new ItemStack(newMaterial, realAmount));
        });
        this.message(this.sender, Message.COMMAND_COMPACT_SUCCESS_ALL, new Object[0]);
        return CommandResultType.SUCCESS;
    }
}

