/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.utils.admins;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.user.Option;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.zutils.utils.AttributeUtils;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import java.util.logging.Level;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class CommandGod
extends VCommand {
    private static final double DEFAULT_MAX_HEALTH = 20.0;
    private static final int DEFAULT_MAX_FOOD_LEVEL = 20;

    public CommandGod(EssentialsPlugin plugin) {
        super(plugin);
        this.setPermission(Permission.ESSENTIALS_GOD);
        this.setDescription(Message.DESCRIPTION_GOD);
        this.addOptionalArg("player", this.getOnlinePlayers());
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        Player player = this.argAsPlayer(0, this.player);
        if (player == null) {
            return CommandResultType.SYNTAX_ERROR;
        }
        if (player == this.player) {
            this.toggleGodMode(player, this.user, this.sender);
        } else {
            if (!this.hasPermission((Permissible)this.sender, Permission.ESSENTIALS_GOD_OTHER)) {
                this.message(this.sender, Message.COMMAND_NO_PERMISSION, new Object[0]);
                return CommandResultType.NO_PERMISSION;
            }
            User otherUser = this.getUser(player);
            this.toggleGodMode(player, otherUser, this.sender);
        }
        return CommandResultType.SUCCESS;
    }

    private void toggleGodMode(Player target, User user, CommandSender sender) {
        boolean wasGodEnabled = user.getOption(Option.GOD);
        user.setOption(Option.GOD, !wasGodEnabled);
        boolean isGodEnabled = user.getOption(Option.GOD);
        if (isGodEnabled) {
            try {
                this.setPlayerHealthAndFood(target);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Error setting god mode health/food for " + target.getName(), e);
                user.setOption(Option.GOD, wasGodEnabled);
                isGodEnabled = wasGodEnabled;
            }
        }
        this.sendGodModeMessages(target, sender, isGodEnabled);
    }

    private void sendGodModeMessages(Player target, CommandSender sender, boolean isGodEnabled) {
        Message messageKey = isGodEnabled ? Message.COMMAND_GOD_ENABLE : Message.COMMAND_GOD_DISABLE;
        boolean isSelf = sender.equals((Object)target);
        String senderMessage = isSelf ? Message.YOU.getMessageAsString() : target.getName();
        this.message(sender, messageKey, "%player%", senderMessage);
        if (!isSelf) {
            this.message((CommandSender)target, messageKey, "%player%", Message.YOU.getMessageAsString());
        }
    }

    private void setPlayerHealthAndFood(Player player) {
        AttributeInstance attributeInstance;
        Attribute maxHealthAttribute = AttributeUtils.getAttribute("max_health");
        double maxHealth = 20.0;
        if (maxHealthAttribute != null && (attributeInstance = player.getAttribute(maxHealthAttribute)) != null) {
            maxHealth = attributeInstance.getBaseValue();
        }
        player.setHealth(maxHealth);
        player.setFoodLevel(20);
    }
}

