/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.vault;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.commands.commands.vault.CommandVaultAddSlot;
import fr.maxlego08.essentials.commands.commands.vault.CommandVaultGive;
import fr.maxlego08.essentials.commands.commands.vault.CommandVaultInfo;
import fr.maxlego08.essentials.commands.commands.vault.CommandVaultSetSlot;
import fr.maxlego08.essentials.commands.commands.vault.CommandVaultShow;
import fr.maxlego08.essentials.module.modules.vault.VaultModule;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;

public class CommandVault
extends VCommand {
    public CommandVault(EssentialsPlugin plugin) {
        super(plugin);
        this.setPermission(Permission.ESSENTIALS_VAULT_USE);
        this.setModule(VaultModule.class);
        this.onlyPlayers();
        this.addOptionalArg("vault id", (sender, args) -> {
            List<Object> list;
            if (sender instanceof Player) {
                Player player = (Player)sender;
                list = plugin.getVaultManager().getVaultAsTabCompletion(player);
            } else {
                list = new ArrayList();
            }
            return list;
        });
        this.addSubCommand(new CommandVaultSetSlot(plugin));
        this.addSubCommand(new CommandVaultAddSlot(plugin));
        this.addSubCommand(new CommandVaultGive(plugin));
        this.addSubCommand(new CommandVaultInfo(plugin));
        this.addSubCommand(new CommandVaultShow(plugin));
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        int vaultId = this.argAsInteger(0, 1);
        plugin.getVaultManager().openVault(this.player, vaultId);
        return CommandResultType.SUCCESS;
    }
}

