/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.convert.playervaultx;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.convert.Convert;
import fr.maxlego08.essentials.api.vault.VaultManager;
import fr.maxlego08.essentials.storage.storages.SqlStorage;
import fr.maxlego08.essentials.zutils.utils.ZUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class PlayerVaultXConvert
extends ZUtils
implements Convert {
    private final EssentialsPlugin plugin;

    public PlayerVaultXConvert(EssentialsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void convert(CommandSender sender) {
        if (!Bukkit.getPluginManager().isPluginEnabled("PlayerVaults")) {
            this.message(sender, "&cYou must have PlayerVaultX on your server to do the conversion.");
            return;
        }
        File file = new File(Bukkit.getWorldContainer(), "plugins/PlayerVaults/newvaults");
        if (!file.exists()) {
            this.message(sender, "&cUnable to find &bplugins/PlayerVaults/newvaults&c.");
            return;
        }
        this.message(sender, "&fStart convert &7PlayerVaultX");
        if (this.plugin.getStorageManager().getStorage() instanceof SqlStorage) {
            this.plugin.getScheduler().runAsync(wrappedTask -> this.startConvertDatabase(sender, file));
        } else {
            this.message(sender, "&cYou must have the storage in a database to be able to convert. Never use the storage in JSON !");
        }
    }

    private void startConvertDatabase(CommandSender sender, File folder) {
        int vaults = 0;
        int players = 0;
        VaultManager manager = this.plugin.getVaultManager();
        File[] files = folder.listFiles();
        if (files == null) {
            this.message(sender, "\u00a7cUnable to find files from vaults.");
            return;
        }
        for (File file : files) {
            UUID uuid;
            if (!file.getName().endsWith(".yml")) continue;
            try {
                uuid = UUID.fromString(file.getName().replace(".yml", ""));
            }
            catch (Exception ignored) {
                continue;
            }
            ++players;
            YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
            for (String vaultName : configuration.getKeys(false)) {
                ItemStack[] itemStacks;
                for (ItemStack itemStack : itemStacks = this.getItems(configuration.getString(vaultName))) {
                    if (itemStack == null || itemStack.getType().isAir()) continue;
                    manager.addItem(uuid, itemStack);
                }
                ++vaults;
            }
        }
        this.message(sender, "&aYou have just converted your PlayerVaultX data to zEssentials !");
        this.message(sender, "&f" + players + " \u00a7aplayers and &f" + vaults + " \u00a7avaults.");
    }

    private ItemStack[] getItems(String base64) {
        try {
            byte[] bytes = Base64Coder.decodeLines((String)base64);
            Class<?> cardBoxSerializationClass = Class.forName("com.drtshock.playervaults.vaultmanagement.CardboardBoxSerialization");
            Method method = cardBoxSerializationClass.getDeclaredMethod("readInventory", byte[].class);
            method.setAccessible(true);
            return (ItemStack[])method.invoke(null, new Object[]{bytes});
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new ItemStack[0];
        }
    }
}

