/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.libs.sarah.requests;

import fr.maxlego08.essentials.libs.sarah.DatabaseConfiguration;
import fr.maxlego08.essentials.libs.sarah.DatabaseConnection;
import fr.maxlego08.essentials.libs.sarah.conditions.ColumnDefinition;
import fr.maxlego08.essentials.libs.sarah.database.Executor;
import fr.maxlego08.essentials.libs.sarah.database.Schema;
import fr.maxlego08.essentials.libs.sarah.logger.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;

public class CreateRequest
implements Executor {
    private final Schema schema;

    public CreateRequest(Schema schema) {
        this.schema = schema;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute(DatabaseConnection databaseConnection, DatabaseConfiguration databaseConfiguration, Logger logger) {
        StringBuilder createTableSQL = new StringBuilder("CREATE TABLE IF NOT EXISTS ");
        createTableSQL.append(this.schema.getTableName()).append(" (");
        ArrayList<String> columnSQLs = new ArrayList<String>();
        for (ColumnDefinition column : this.schema.getColumns()) {
            columnSQLs.add(column.build(databaseConfiguration));
        }
        createTableSQL.append(String.join((CharSequence)", ", columnSQLs));
        if (!this.schema.getPrimaryKeys().isEmpty()) {
            createTableSQL.append(", PRIMARY KEY (").append(String.join((CharSequence)", ", this.schema.getPrimaryKeys())).append(")");
        }
        for (String fk : this.schema.getForeignKeys()) {
            createTableSQL.append(", ").append(fk);
        }
        createTableSQL.append(")");
        String finalQuery = databaseConfiguration.replacePrefix(createTableSQL.toString());
        if (databaseConfiguration.isDebug()) {
            logger.info("Executing SQL: " + finalQuery);
        }
        try (Connection connection = databaseConnection.getConnection();){
            int n;
            block18: {
                PreparedStatement preparedStatement = connection.prepareStatement(finalQuery);
                try {
                    preparedStatement.execute();
                    n = preparedStatement.getUpdateCount();
                    if (preparedStatement == null) break block18;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return n;
        }
        catch (SQLException exception) {
            exception.printStackTrace();
            return -1;
        }
    }
}

