/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.libs.sarah.requests;

import fr.maxlego08.essentials.libs.sarah.DatabaseConfiguration;
import fr.maxlego08.essentials.libs.sarah.DatabaseConnection;
import fr.maxlego08.essentials.libs.sarah.conditions.ColumnDefinition;
import fr.maxlego08.essentials.libs.sarah.conditions.JoinCondition;
import fr.maxlego08.essentials.libs.sarah.database.Executor;
import fr.maxlego08.essentials.libs.sarah.database.Schema;
import fr.maxlego08.essentials.libs.sarah.logger.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;

public class UpdateRequest
implements Executor {
    private final Schema schema;

    public UpdateRequest(Schema schema) {
        this.schema = schema;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute(DatabaseConnection databaseConnection, DatabaseConfiguration databaseConfiguration, Logger logger) {
        StringBuilder updateQuery = new StringBuilder("UPDATE " + this.schema.getTableName());
        if (!this.schema.getJoinConditions().isEmpty()) {
            for (JoinCondition join : this.schema.getJoinConditions()) {
                updateQuery.append(" ").append(join.getJoinClause());
            }
        }
        updateQuery.append(" SET ");
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < this.schema.getColumns().size(); ++i) {
            ColumnDefinition columnDefinition = this.schema.getColumns().get(i);
            updateQuery.append(i > 0 ? ", " : "").append(columnDefinition.getSafeName()).append(" = ?");
            values.add(columnDefinition.getObject());
        }
        this.schema.whereConditions(updateQuery);
        String updateSql = databaseConfiguration.replacePrefix(updateQuery.toString());
        if (databaseConfiguration.isDebug()) {
            logger.info("Executing SQL: " + updateSql);
        }
        try (Connection connection = databaseConnection.getConnection();){
            int n;
            block19: {
                PreparedStatement preparedStatement = connection.prepareStatement(updateSql);
                try {
                    for (int i = 0; i < values.size(); ++i) {
                        preparedStatement.setObject(i + 1, values.get(i));
                    }
                    this.schema.applyWhereConditions(preparedStatement, values.size() + 1);
                    preparedStatement.executeUpdate();
                    n = preparedStatement.getUpdateCount();
                    if (preparedStatement == null) break block19;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return n;
        }
        catch (SQLException exception) {
            exception.printStackTrace();
            return -1;
        }
    }
}

