/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.loader;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.user.Option;
import fr.maxlego08.essentials.buttons.ButtonOption;
import fr.maxlego08.menu.api.MenuItemStack;
import fr.maxlego08.menu.api.button.Button;
import fr.maxlego08.menu.api.button.DefaultButtonValue;
import fr.maxlego08.menu.api.loader.ButtonLoader;
import java.io.File;
import java.util.List;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ButtonOptionLoader
extends ButtonLoader {
    private final EssentialsPlugin plugin;

    public ButtonOptionLoader(EssentialsPlugin plugin) {
        super((Plugin)plugin, "ZESSENTIALS_OPTION");
        this.plugin = plugin;
    }

    public Button load(YamlConfiguration configuration, String path, DefaultButtonValue defaultButtonValue) {
        File file = new File(this.plugin.getDataFolder(), "inventories/options.yml");
        List offsetSlots = configuration.getIntegerList(path + "offset-slots");
        Option option = Option.valueOf(configuration.getString(path + "option", Option.PRIVATE_MESSAGE_DISABLE.name()).toUpperCase());
        MenuItemStack enableItemStack = this.load(configuration, path + "enable-item.", file);
        MenuItemStack disableItemStack = this.load(configuration, path + "disable-item.", file);
        MenuItemStack offsetEnableItemStack = this.load(configuration, path + "offset-enable-item.", file);
        MenuItemStack offsetDisableItemStack = this.load(configuration, path + "offset-disable-item.", file);
        return new ButtonOption(this.plugin, option, offsetSlots, enableItemStack, disableItemStack, offsetEnableItemStack, offsetDisableItemStack);
    }

    private MenuItemStack load(YamlConfiguration configuration, String path, File file) {
        return this.plugin.getInventoryManager().loadItemStack(configuration, path, file);
    }
}

