/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.messages;

import fr.maxlego08.essentials.ZEssentialsPlugin;
import fr.maxlego08.essentials.api.ConfigurationFile;
import fr.maxlego08.essentials.api.messages.EssentialsMessage;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.messages.MessageType;
import fr.maxlego08.essentials.api.messages.messages.BossBarMessage;
import fr.maxlego08.essentials.api.messages.messages.ClassicMessage;
import fr.maxlego08.essentials.api.messages.messages.TitleMessage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageLoader
implements ConfigurationFile {
    private final Locale locale = Locale.getDefault();
    private final ZEssentialsPlugin plugin;
    private final List<Message> loadedMessages = new ArrayList<Message>();

    public MessageLoader(ZEssentialsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void load() {
        File file = new File(this.plugin.getDataFolder(), "messages.yml");
        this.copyFile();
        this.loadMessages(YamlConfiguration.loadConfiguration((File)file));
        if (this.loadedMessages.size() != Message.values().length) {
            this.plugin.getLogger().log(Level.SEVERE, "Messages were not loaded correctly.");
            for (Message value : Message.values()) {
                if (this.loadedMessages.contains((Object)value)) continue;
                value.setPlugin(this.plugin);
                this.plugin.getLogger().log(Level.SEVERE, String.valueOf((Object)value) + " was not loaded.");
                ArrayList<EssentialsMessage> newMessages = new ArrayList<EssentialsMessage>();
                for (EssentialsMessage message : value.getMessages()) {
                    if (message instanceof ClassicMessage) {
                        ClassicMessage classicMessage = (ClassicMessage)message;
                        newMessages.add(new ClassicMessage(classicMessage.messageType(), classicMessage.messages().stream().map(this::replaceMessagesColors).toList()));
                        continue;
                    }
                    if (message instanceof BossBarMessage) {
                        BossBarMessage bossBarMessage = (BossBarMessage)message;
                        newMessages.add(new BossBarMessage(this.replaceMessagesColors(bossBarMessage.text()), bossBarMessage.color(), bossBarMessage.overlay(), bossBarMessage.flags(), bossBarMessage.duration(), bossBarMessage.isStatic()));
                        continue;
                    }
                    if (!(message instanceof TitleMessage)) continue;
                    TitleMessage titleMessage = (TitleMessage)message;
                    newMessages.add(new TitleMessage(this.replaceMessagesColors(titleMessage.title()), this.replaceMessagesColors(titleMessage.subtitle()), titleMessage.start(), titleMessage.time(), titleMessage.end()));
                }
                value.setMessages(newMessages);
            }
        }
    }

    private void copyFile() {
        Object messageFileName = "messages";
        String localMessageName = "messages_" + this.locale.getLanguage();
        if (this.plugin.resourceExist("messages/" + localMessageName + ".yml")) {
            messageFileName = localMessageName;
        }
        this.plugin.saveOrUpdateConfiguration("messages/" + (String)messageFileName + ".yml", "messages.yml", false);
    }

    private void loadMessages(YamlConfiguration configuration) {
        this.loadedMessages.clear();
        for (String key : configuration.getKeys(false)) {
            String messageKey = key.replace("-", "_").toUpperCase();
            try {
                Message message = Message.fromString(messageKey);
                if (message == null) {
                    this.plugin.getLogger().severe("Impossible to find the message " + key + ", it does not exist, you must delete it.");
                    continue;
                }
                message.setPlugin(this.plugin);
                ArrayList<EssentialsMessage> essentialsMessages = new ArrayList<EssentialsMessage>();
                List mapList = configuration.getMapList(key);
                if (!mapList.isEmpty()) {
                    for (int index = 0; index != mapList.size(); ++index) {
                        MessageType messageType;
                        String path = key + " and index " + (index + 1);
                        Map map = (Map)mapList.get(index);
                        MessageType messageType2 = messageType = map.containsKey("type") ? MessageType.fromString((String)map.get("type")) : MessageType.TCHAT;
                        if (messageType == null) {
                            messageType = MessageType.TCHAT;
                            this.plugin.getLogger().severe("Message type was not found for " + path + ", use TCHAT by default.");
                        }
                        if (messageType == MessageType.BOSSBAR) {
                            boolean isStatic;
                            long duration;
                            List flags;
                            String overlay;
                            String color;
                            String text = this.replaceMessagesColors(this.getValue(map, "text", path, "Default text", true));
                            BossBarMessage bossBarMessage = new BossBarMessage(text, color = this.getValue(map, "color", path, "WHITE", false), overlay = this.getValue(map, "overlay", path, "PROGRESS", false), flags = (List)this.getValue(map, "flags", path, new ArrayList(), false), duration = this.getValue(map, "duration", path, 60L, false).longValue(), isStatic = this.getValue(map, "static", path, false, false).booleanValue());
                            if (!bossBarMessage.isValid(this.plugin)) continue;
                            essentialsMessages.add(bossBarMessage);
                            continue;
                        }
                        if (messageType == MessageType.TITLE) {
                            String title = this.replaceMessagesColors(this.getValue(map, "title", path, "Default title", true));
                            String subtitle = this.replaceMessagesColors(this.getValue(map, "subtitle", path, "Default subtitle", true));
                            long start = this.getValue(map, "start", path, 100L, false);
                            long time = this.getValue(map, "time", path, 2800L, false);
                            long end = this.getValue(map, "end", path, 100L, false);
                            TitleMessage essentialsMessage = new TitleMessage(title, subtitle, start, time, end);
                            essentialsMessages.add(essentialsMessage);
                            continue;
                        }
                        List<String> messages = this.getMessage(map);
                        messages.removeIf(Objects::isNull);
                        if (messages.isEmpty()) {
                            this.plugin.getLogger().severe("Message is empty for " + key + " and index " + index + ", use default configuration.");
                            continue;
                        }
                        ClassicMessage essentialsMessage = new ClassicMessage(messageType, messages.stream().map(this::replaceMessagesColors).collect(Collectors.toList()));
                        essentialsMessages.add(essentialsMessage);
                    }
                } else if (configuration.contains(key + ".type")) {
                    MessageType messageType = MessageType.fromString(configuration.getString(key + ".type", "TCHAT"));
                    if (messageType == null) {
                        messageType = MessageType.TCHAT;
                        this.plugin.getLogger().severe("Message type was not found for " + key + ", use TCHAT by default.");
                    }
                    if (messageType == MessageType.TITLE) {
                        String title = this.replaceMessagesColors(configuration.getString(key + ".title", "Default title"));
                        String subtitle = this.replaceMessagesColors(configuration.getString(key + ".subtitle", "Default subtitle"));
                        long start = configuration.getLong(key + ".start", 100L);
                        long time = configuration.getLong(key + ".time", 2800L);
                        long end = configuration.getLong(key + ".end", 100L);
                        TitleMessage essentialsMessage = new TitleMessage(title, subtitle, start, time, end);
                        essentialsMessages.add(essentialsMessage);
                    } else if (messageType == MessageType.BOSSBAR) {
                        boolean isStatic;
                        long duration;
                        List flags;
                        String overlay;
                        String color;
                        String text = this.replaceMessagesColors(configuration.getString(key + ".text", "Default Text"));
                        BossBarMessage bossBarMessage = new BossBarMessage(text, color = configuration.getString("color", "WHITE"), overlay = configuration.getString("overlay", "PROGRESS"), flags = configuration.getStringList("flags"), duration = configuration.getLong("duration", 60L), isStatic = configuration.getBoolean("static", false));
                        if (bossBarMessage.isValid(this.plugin)) {
                            essentialsMessages.add(bossBarMessage);
                        }
                    } else {
                        List<String> messages = configuration.getStringList(key + ".messages");
                        if (messages.isEmpty()) {
                            messages.add(this.replaceMessagesColors(configuration.getString(key + ".message")));
                        } else {
                            messages = messages.stream().map(this::replaceMessagesColors).collect(Collectors.toList());
                        }
                        messages.removeIf(Objects::isNull);
                        if (messages.isEmpty()) {
                            this.plugin.getLogger().severe("Message is empty for " + key + ", use default configuration.");
                        } else {
                            ClassicMessage essentialsMessage = new ClassicMessage(messageType, messages);
                            essentialsMessages.add(essentialsMessage);
                        }
                    }
                } else {
                    List<String> messages = configuration.getStringList(key);
                    if (messages.isEmpty()) {
                        messages.add(this.replaceMessagesColors(configuration.getString(key)));
                    } else {
                        messages = messages.stream().map(this::replaceMessagesColors).collect(Collectors.toList());
                    }
                    messages.removeIf(Objects::isNull);
                    if (messages.isEmpty()) {
                        this.plugin.getLogger().severe("Message is empty for " + key + ", use default configuration.");
                    } else {
                        ClassicMessage essentialsMessage = new ClassicMessage(MessageType.TCHAT, messages);
                        essentialsMessages.add(essentialsMessage);
                    }
                }
                message.setMessages(essentialsMessages);
                this.loadedMessages.add(message);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.plugin.getLogger().log(Level.SEVERE, messageKey + " key was not found !");
            }
        }
    }

    private String replaceMessagesColors(String message) {
        return this.plugin.getConfiguration().getMessageColors().stream().reduce(message, (msg, color) -> msg.replace(color.key(), color.color()), (msg1, msg2) -> msg1);
    }

    private List<String> getMessage(Map<?, ?> map) {
        ArrayList<String> messages = new ArrayList<String>();
        for (String key : new String[]{"messages", "message"}) {
            Object value = map.get(key);
            if (value instanceof List) {
                for (Object item : (List)value) {
                    if (item == null) continue;
                    messages.add(item.toString());
                }
                continue;
            }
            if (value == null) continue;
            messages.add(value.toString());
        }
        return messages;
    }

    private <T> T getValue(Map<?, ?> map, String key, String path, T defaultValue, boolean isRequired) {
        if (map.containsKey(key)) {
            Object value = map.get(key);
            if (defaultValue instanceof Integer && value instanceof Number) {
                Number number = (Number)value;
                return (T)Integer.valueOf(number.intValue());
            }
            if (defaultValue instanceof Long && value instanceof Number) {
                Number number = (Number)value;
                return (T)Long.valueOf(number.longValue());
            }
            if (defaultValue instanceof Double && value instanceof Number) {
                Number number = (Number)value;
                return (T)Double.valueOf(number.doubleValue());
            }
            if (defaultValue instanceof Float && value instanceof Number) {
                Number number = (Number)value;
                return (T)Float.valueOf(number.floatValue());
            }
            if (defaultValue instanceof Boolean && value instanceof Boolean) {
                return (T)value;
            }
            if (defaultValue instanceof String && value instanceof String) {
                return (T)value;
            }
            if (defaultValue != null && defaultValue.getClass().isInstance(value)) {
                return (T)value;
            }
            if (defaultValue == null && value != null) {
                try {
                    return (T)value;
                }
                catch (ClassCastException ignored) {
                    this.plugin.getLogger().severe("Type mismatch for the key " + key + " for the message " + path);
                }
            } else {
                this.plugin.getLogger().severe("Type mismatch for the key " + key + " for the message " + path);
            }
        }
        if (isRequired) {
            this.plugin.getLogger().severe("Unable to find the key " + key + " for the message " + path);
        }
        return defaultValue;
    }
}

