/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.module.modules;

import fr.maxlego08.essentials.ZEssentialsPlugin;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.module.ZModule;
import fr.maxlego08.menu.api.MenuItemStack;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.Nullable;

public class ItemModule
extends ZModule {
    private final Map<String, MenuItemStack> items = new HashMap<String, MenuItemStack>();

    public ItemModule(ZEssentialsPlugin plugin) {
        super(plugin, "items");
    }

    @Override
    public void loadConfiguration() {
        super.loadConfiguration();
        YamlConfiguration configuration = this.getConfiguration();
        ConfigurationSection configurationSection = configuration.getConfigurationSection("custom-items");
        if (configurationSection == null) {
            return;
        }
        for (String itemName : configurationSection.getKeys(false)) {
            MenuItemStack menuItemStack = this.plugin.getInventoryManager().loadItemStack(configuration, "custom-items." + itemName + ".", new File(this.getFolder(), "config.yml"));
            this.items.put(itemName, menuItemStack);
        }
    }

    public Map<String, MenuItemStack> getItems() {
        return this.items;
    }

    public Set<String> getItemsName() {
        return this.items.keySet();
    }

    public boolean isItem(String itemName) {
        if (this.items.containsKey(itemName)) {
            return true;
        }
        try {
            Material.valueOf((String)itemName.toUpperCase());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Nullable
    public ItemStack getItemStack(String itemName, OfflinePlayer playerPlayer) {
        if (this.items.containsKey(itemName)) {
            return this.items.get(itemName).build(playerPlayer.isOnline() ? playerPlayer.getPlayer() : null, false);
        }
        try {
            Material material = Material.valueOf((String)itemName.toUpperCase());
            return new ItemStack(material);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void give(CommandSender sender, Player player, String itemName, int amount) {
        ItemStack itemStack = this.getItemStack(itemName, (OfflinePlayer)player);
        if (itemStack == null) {
            this.message(sender, Message.COMMAND_GIVE_ERROR, "%item%", itemName);
            return;
        }
        itemStack.setAmount(Math.max(1, amount));
        this.plugin.give(player, itemStack);
        this.message(sender, Message.COMMAND_GIVE, "%item%", itemName, "%player%", player.getName(), "%amount%", amount);
    }

    public void giveFullInventory(CommandSender sender, Player player, String itemName) {
        ItemStack itemStack = this.getItemStack(itemName, (OfflinePlayer)player);
        if (itemStack == null) {
            this.message(sender, Message.COMMAND_GIVE_ERROR, "%item%", itemName);
            return;
        }
        itemStack.setAmount(itemStack.getMaxStackSize());
        int amount = 0;
        PlayerInventory inventory = player.getInventory();
        for (int slot = 0; slot != 36; ++slot) {
            if (inventory.getContents()[slot] != null && !inventory.getContents()[slot].getType().isAir()) continue;
            inventory.setItem(slot, itemStack.clone());
            amount += itemStack.getAmount();
        }
        this.message(sender, Message.COMMAND_GIVE, "%item%", itemName, "%player%", player.getName(), "%amount%", amount);
    }

    public void giveAll(CommandSender sender, String itemName, int amount) {
        if (!this.isItem(itemName)) {
            this.message(sender, Message.COMMAND_GIVE_ERROR, "%item%", itemName);
            return;
        }
        Bukkit.getOnlinePlayers().forEach(player -> {
            ItemStack itemStack = this.getItemStack(itemName, (OfflinePlayer)player);
            if (itemStack == null) {
                return;
            }
            itemStack.setAmount(Math.max(1, amount));
            this.plugin.give((Player)player, itemStack);
        });
        this.message(sender, Message.COMMAND_GIVE_ALL, "%item%", itemName, "%amount%", amount);
    }
}

