/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.module.modules;

import fr.maxlego08.essentials.ZEssentialsPlugin;
import fr.maxlego08.essentials.api.cache.ExpiringCache;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.dto.UserDTO;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.sanction.Sanction;
import fr.maxlego08.essentials.api.sanction.SanctionManager;
import fr.maxlego08.essentials.api.sanction.SanctionType;
import fr.maxlego08.essentials.api.server.EssentialsServer;
import fr.maxlego08.essentials.api.storage.IStorage;
import fr.maxlego08.essentials.api.user.Option;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.api.user.UserRecord;
import fr.maxlego08.essentials.api.utils.SafeLocation;
import fr.maxlego08.essentials.listener.spigot.ChatListener;
import fr.maxlego08.essentials.module.ZModule;
import fr.maxlego08.essentials.user.ZUser;
import fr.maxlego08.essentials.zutils.utils.TimerBuilder;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class SanctionModule
extends ZModule
implements SanctionManager {
    private final ExpiringCache<UUID, User> expiringCache = new ExpiringCache(3600000L);
    private final String kickDefaultReason = "";
    private final String banDefaultReason = "";
    private final String muteDefaultReason = "";
    private final String unmuteDefaultReason = "";
    private final String unbanDefaultReason = "";
    private final String dateFormat = "yyyy-MM-dd HH:mm:ss";
    private final Material kickMaterial = Material.BOOK;
    private final Material banMaterial = Material.BOOK;
    private final Material muteMaterial = Material.BOOK;
    private final Material unbanMaterial = Material.BOOK;
    private final Material unmuteMaterial = Material.BOOK;
    private final Material warnMaterial = Material.BOOK;
    private final Material freezeMaterial = Material.BOOK;
    private final Material currentMuteMaterial = Material.BOOKSHELF;
    private final Material currentBanMaterial = Material.BOOKSHELF;
    private final List<String> protections = new ArrayList<String>();
    private SimpleDateFormat simpleDateFormat;

    public SanctionModule(ZEssentialsPlugin plugin) {
        super(plugin, "sanction");
        Bukkit.getPluginManager().registerEvents((Listener)(this.isPaperVersion() ? new fr.maxlego08.essentials.listener.paper.ChatListener(plugin) : new ChatListener(plugin)), (Plugin)plugin);
    }

    @Override
    public void loadConfiguration() {
        super.loadConfiguration();
        this.loadInventory("sanction");
        this.loadInventory("sanction_history");
        this.loadInventory("sanctions");
        this.simpleDateFormat = new SimpleDateFormat(this.dateFormat);
    }

    public String getDateFormat() {
        return "yyyy-MM-dd HH:mm:ss";
    }

    public String getKickDefaultReason() {
        return "";
    }

    public String getBanDefaultReason() {
        return "";
    }

    public String getMuteDefaultReason() {
        return "";
    }

    public String getUnbanDefaultReason() {
        return "";
    }

    public String getUnmuteDefaultReason() {
        return "";
    }

    public Material getSanctionMaterial(SanctionType sanctionType, boolean isActive) {
        return switch (sanctionType) {
            default -> throw new MatchException(null, null);
            case SanctionType.KICK -> this.kickMaterial;
            case SanctionType.MUTE -> {
                if (isActive) {
                    yield this.currentMuteMaterial;
                }
                yield this.muteMaterial;
            }
            case SanctionType.BAN -> {
                if (isActive) {
                    yield this.currentBanMaterial;
                }
                yield this.banMaterial;
            }
            case SanctionType.UNBAN -> this.unbanMaterial;
            case SanctionType.UNMUTE -> this.unmuteMaterial;
            case SanctionType.WARN -> this.warnMaterial;
            case SanctionType.FREEZE -> this.freezeMaterial;
        };
    }

    @Override
    public UUID getSenderUniqueId(CommandSender sender) {
        UUID uUID;
        if (sender instanceof Player) {
            Player player = (Player)sender;
            uUID = player.getUniqueId();
        } else {
            uUID = this.plugin.getConsoleUniqueId();
        }
        return uUID;
    }

    @Override
    public void kick(CommandSender sender, UUID uuid, String playerName, String reason) {
        if (this.isProtected(playerName)) {
            this.message(sender, Message.COMMAND_SANCTION_ERROR, new Object[0]);
            return;
        }
        EssentialsServer server = this.plugin.getEssentialsServer();
        IStorage iStorage = this.plugin.getStorageManager().getStorage();
        Sanction sanction = Sanction.kick(uuid, this.getSenderUniqueId(sender), reason);
        iStorage.insertSanction(sanction, sanction::setId);
        this.expiringCache.clear(uuid);
        server.kickPlayer(uuid, Message.MESSAGE_KICK, "%reason%", reason);
        server.broadcastMessage(Permission.ESSENTIALS_KICK_NOTIFY, Message.COMMAND_KICK_NOTIFY, "%player%", sender.getName(), "%target%", playerName, "%reason%", reason, "%sender%", this.getSanctionBy(sender), "%created_at%", this.simpleDateFormat.format(new Date()));
    }

    @Override
    public void ban(CommandSender sender, UUID uuid, String playerName, Duration duration, String reason) {
        if (this.isProtected(playerName)) {
            this.message(sender, Message.COMMAND_SANCTION_ERROR, new Object[0]);
            return;
        }
        EssentialsServer server = this.plugin.getEssentialsServer();
        IStorage iStorage = this.plugin.getStorageManager().getStorage();
        if (duration.isZero()) {
            this.message(sender, Message.COMMAND_BAN_ERROR_DURATION, new Object[0]);
            return;
        }
        Date finishAt = new Date(System.currentTimeMillis() + duration.toMillis());
        Sanction sanction = Sanction.ban(uuid, this.getSenderUniqueId(sender), reason, duration, finishAt);
        iStorage.insertSanction(sanction, index -> {
            sanction.setId((int)index);
            iStorage.updateUserBan(uuid, (Integer)index);
        });
        this.expiringCache.clear(uuid);
        String durationString = TimerBuilder.getStringTime(duration.toMillis());
        server.kickPlayer(uuid, Message.MESSAGE_BAN, "%reason%", reason, "%duration%", TimerBuilder.getStringTime(duration.toMillis()));
        server.broadcastMessage(Permission.ESSENTIALS_BAN_NOTIFY, Message.COMMAND_BAN_NOTIFY, "%player%", sender.getName(), "%target%", playerName, "%reason%", reason, "%duration%", durationString, "%sender%", this.getSanctionBy(sender), "%created_at%", this.simpleDateFormat.format(new Date()), "%expired_at%", this.simpleDateFormat.format(sanction.getExpiredAt()));
    }

    @Override
    public void mute(CommandSender sender, UUID uuid, String playerName, Duration duration, String reason) {
        if (this.isProtected(playerName)) {
            this.message(sender, Message.COMMAND_SANCTION_ERROR, new Object[0]);
            return;
        }
        EssentialsServer server = this.plugin.getEssentialsServer();
        IStorage iStorage = this.plugin.getStorageManager().getStorage();
        if (duration.isZero()) {
            this.message(sender, Message.COMMAND_MUTE_ERROR_DURATION, new Object[0]);
            return;
        }
        Date finishAt = new Date(System.currentTimeMillis() + duration.toMillis());
        Sanction sanction = Sanction.mute(uuid, this.getSenderUniqueId(sender), reason, duration, finishAt);
        iStorage.insertSanction(sanction, index -> {
            sanction.setId((int)index);
            iStorage.updateUserMute(uuid, (Integer)index);
            User user = iStorage.getUser(uuid);
            if (user != null) {
                user.setMuteSanction(sanction);
            }
        });
        this.expiringCache.clear(uuid);
        server.sendMessage(uuid, Message.MESSAGE_MUTE, "%reason%", reason, "%duration%", TimerBuilder.getStringTime(duration.toMillis()));
        server.broadcastMessage(Permission.ESSENTIALS_MUTE_NOTIFY, Message.COMMAND_MUTE_NOTIFY, "%player%", sender.getName(), "%target%", playerName, "%reason%", reason, "%duration%", TimerBuilder.getStringTime(duration.toMillis()), "%sender%", this.getSanctionBy(sender), "%created_at%", this.simpleDateFormat.format(new Date()), "%expired_at%", this.simpleDateFormat.format(sanction.getExpiredAt()));
    }

    @Override
    public void unmute(CommandSender sender, UUID uuid, String playerName, String reason) {
        if (this.isProtected(playerName)) {
            this.message(sender, Message.COMMAND_SANCTION_ERROR, new Object[0]);
            return;
        }
        IStorage iStorage = this.plugin.getStorageManager().getStorage();
        User user = iStorage.getUser(uuid);
        if (user == null) {
            this.plugin.getScheduler().runAsync(wrappedTask -> {
                if (!iStorage.isMute(uuid)) {
                    this.message(sender, Message.COMMAND_UN_MUTE_ERROR, "%player%", playerName);
                    return;
                }
                this.processUnmute(sender, uuid, playerName, reason);
            });
        } else {
            if (!user.isMute()) {
                this.message(sender, Message.COMMAND_UN_MUTE_ERROR, "%player%", playerName);
                return;
            }
            this.processUnmute(sender, uuid, playerName, reason);
        }
    }

    @Override
    public void processUnmute(CommandSender sender, UUID uuid, String playerName, String reason) {
        EssentialsServer server = this.plugin.getEssentialsServer();
        IStorage iStorage = this.plugin.getStorageManager().getStorage();
        Sanction sanction = Sanction.unmute(uuid, this.getSenderUniqueId(sender), reason);
        iStorage.insertSanction(sanction, index -> {
            sanction.setId((int)index);
            iStorage.updateUserMute(uuid, null);
            User user = iStorage.getUser(uuid);
            if (user != null) {
                user.setMuteSanction(null);
            }
        });
        this.expiringCache.clear(uuid);
        server.sendMessage(uuid, Message.MESSAGE_UNMUTE, "%reason%", reason);
        server.broadcastMessage(Permission.ESSENTIALS_UNMUTE_NOTIFY, Message.COMMAND_UNMUTE_NOTIFY, "%player%", sender.getName(), "%target%", playerName, "%reason%", reason, "%sender%", this.getSanctionBy(sender), "%created_at%", this.simpleDateFormat.format(new Date()), "%duration%", "0");
    }

    @Override
    public void unban(CommandSender sender, UUID uuid, String playerName, String reason) {
        if (this.isProtected(playerName)) {
            this.message(sender, Message.COMMAND_SANCTION_ERROR, new Object[0]);
            return;
        }
        EssentialsServer server = this.plugin.getEssentialsServer();
        IStorage iStorage = this.plugin.getStorageManager().getStorage();
        if (!iStorage.isBan(uuid)) {
            this.message(sender, Message.COMMAND_UN_BAN_ERROR, "%player%", playerName);
            return;
        }
        Sanction sanction = Sanction.unban(uuid, this.getSenderUniqueId(sender), reason);
        iStorage.insertSanction(sanction, index -> {
            sanction.setId((int)index);
            iStorage.updateUserBan(uuid, null);
        });
        this.expiringCache.clear(uuid);
        server.broadcastMessage(Permission.ESSENTIALS_UNBAN_NOTIFY, Message.COMMAND_UNBAN_NOTIFY, "%player%", sender.getName(), "%target%", playerName, "%reason%", reason, "%sender%", this.getSanctionBy(sender), "%created_at%", this.simpleDateFormat.format(new Date()), "%duration%", "0");
    }

    @Override
    public void openSanction(User user, UUID uuid, String userName) {
        IStorage iStorage = this.plugin.getStorageManager().getStorage();
        this.plugin.getScheduler().runAsync(wrappedTask -> {
            user.setTargetUser(this.expiringCache.get(uuid, () -> {
                User fakeUser = ZUser.fakeUser(this.plugin, uuid, userName);
                Sanction muteSanction = iStorage.getMute(uuid);
                fakeUser.setFakeOption(Option.BAN, iStorage.isBan(uuid));
                fakeUser.setFakeOption(Option.MUTE, muteSanction != null && muteSanction.isActive());
                fakeUser.setMuteSanction(muteSanction);
                fakeUser.setBanSanction(iStorage.getBan(uuid));
                fakeUser.setFakeSanctions(iStorage.getSanctions(uuid));
                return fakeUser;
            }));
            this.plugin.openInventory(user.getPlayer(), "sanction");
        });
    }

    @Override
    public String getSanctionBy(UUID senderUniqueId) {
        return senderUniqueId.equals(this.plugin.getConsoleUniqueId()) ? Message.CONSOLE.getMessageAsString() : Bukkit.getOfflinePlayer((UUID)senderUniqueId).getName();
    }

    @Override
    public String getSanctionBy(CommandSender sender) {
        String string;
        if (sender instanceof Player) {
            Player player = (Player)sender;
            string = player.getName();
        } else {
            string = Message.CONSOLE.getMessageAsString();
        }
        return string;
    }

    @Override
    public boolean isProtected(String username) {
        return this.protections.stream().anyMatch(name -> name.equalsIgnoreCase(username));
    }

    @Override
    public void seen(CommandSender sender, UUID uuid) {
        boolean isOnline;
        IStorage iStorage = this.plugin.getStorageManager().getStorage();
        UserRecord record = iStorage.fetchUserRecord(uuid);
        UserDTO user = record.userDTO();
        boolean bl = isOnline = Bukkit.getPlayer((UUID)user.unique_id()) != null;
        if (isOnline) {
            this.sendOnline(sender, record);
        } else {
            this.sendOffline(sender, record);
        }
        this.message(sender, Message.COMMAND_SEEN_UUID, "%uuid%", uuid.toString());
        if (this.hasPermission((Permissible)sender, Permission.ESSENTIALS_SEEN_SHOW_IP)) {
            this.message(sender, Message.COMMAND_SEEN_IP, "%ips%", record.playTimeDTOS().stream().map(timeDTO -> this.getMessage(Message.COMMAND_SEEN_ADDRESS, "%ip%", timeDTO.address())).distinct().collect(Collectors.joining(",")));
        }
        if (user.last_location() != null && this.hasPermission((Permissible)sender, Permission.ESSENTIALS_SEEN_SHOW_LAST_LOCATION)) {
            SafeLocation location = this.stringAsLocation(user.last_location());
            this.message(sender, Message.COMMAND_SEEN_LAST_LOCATION, "%x%", location.getBlockX(), "%z%", location.getBlockZ(), "%y%", location.getBlockY(), "%world%", location.getWorld());
        }
        if (user.created_at() != null && this.hasPermission((Permissible)sender, Permission.ESSENTIALS_SEEN_SHOW_CREATED_AT)) {
            this.message(sender, Message.COMMAND_SEEN_FIRST_JOIN, "%created_at%", this.simpleDateFormat.format(user.created_at()));
        }
    }

    private void sendOnline(CommandSender sender, UserRecord record) {
        User user = this.plugin.getUser(record.userDTO().unique_id());
        this.message(sender, Message.COMMAND_SEEN_ONLINE, "%player%", record.userDTO().name(), "%date%", TimerBuilder.getStringTime(System.currentTimeMillis() - user.getCurrentSessionPlayTime()));
        this.message(sender, Message.COMMAND_SEEN_PLAYTIME, "%playtime%", TimerBuilder.getStringTime(user.getPlayTime() * 1000L));
    }

    private void sendOffline(CommandSender sender, UserRecord record) {
        this.message(sender, Message.COMMAND_SEEN_OFFLINE, "%player%", record.userDTO().name(), "%date%", this.simpleDateFormat.format(record.userDTO().updated_at()));
        this.message(sender, Message.COMMAND_SEEN_PLAYTIME, "%playtime%", TimerBuilder.getStringTime(record.userDTO().play_time() * 1000L));
    }

    @Override
    public void seen(CommandSender sender, String ip) {
        IStorage iStorage = this.plugin.getStorageManager().getStorage();
        List<UserDTO> userDTOS = iStorage.getUsers(ip);
        if (userDTOS.isEmpty()) {
            this.message(sender, Message.COMMAND_SEEN_IP_EMPTY, "%ip%", ip);
            return;
        }
        this.message(sender, Message.COMMAND_SEEN_IP_LINE, "%ip%", ip, "%players%", userDTOS.stream().map(user -> this.getMessage(Message.COMMAND_SEEN_IP_INFO, "%name%", user.name())).collect(Collectors.joining(",")));
    }

    @Override
    public void freeze(CommandSender sender, UUID uuid, String userName) {
        if (this.isProtected(userName)) {
            this.message(sender, Message.COMMAND_SANCTION_ERROR, new Object[0]);
            return;
        }
        User user = this.plugin.getUser(uuid);
        if (user == null) {
            this.message(sender, Message.PLAYER_NOT_FOUND, "%player%", userName);
            return;
        }
        user.setFrozen(!user.isFrozen());
        IStorage iStorage = this.plugin.getStorageManager().getStorage();
        Sanction sanction = Sanction.freeze(uuid, this.getSenderUniqueId(sender));
        iStorage.insertSanction(sanction, index -> {
            sanction.setId((int)index);
            iStorage.updateUserFrozen(uuid, user.isFrozen());
        });
        Player player = user.getPlayer();
        if (user.isFrozen()) {
            this.message(sender, Message.COMMAND_FREEZE_SUCCESS, "%player%", userName);
            this.plugin.getEssentialsServer().sendMessage(uuid, Message.MESSAGE_FREEZE, new Object[0]);
            player.setAllowFlight(true);
            player.setFlying(true);
            player.setFlySpeed(0.0f);
            this.plugin.getScheduler().teleportAsync((Entity)user.getPlayer(), user.getPlayer().getLocation().add(0.0, 0.1, 0.0));
        } else {
            player.setAllowFlight(false);
            player.setFlying(false);
            player.setFlySpeed(0.1f);
            this.message(sender, Message.COMMAND_UN_FREEZE_SUCCESS, "%player%", userName);
            this.plugin.getEssentialsServer().sendMessage(uuid, Message.MESSAGE_UN_FREEZE, new Object[0]);
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        User user = this.getUser((Entity)event.getPlayer());
        if (user != null && user.isFrozen()) {
            user.getPlayer().setAllowFlight(true);
            user.getPlayer().setFlying(true);
            user.getPlayer().setFlySpeed(0.0f);
            this.plugin.getScheduler().teleportAsync((Entity)user.getPlayer(), user.getPlayer().getLocation().add(0.0, 0.1, 0.0));
            this.plugin.getEssentialsServer().sendMessage(user.getUniqueId(), Message.MESSAGE_FREEZE, new Object[0]);
        }
    }

    @EventHandler
    public void onCommand(PlayerCommandPreprocessEvent event) {
        User user = this.getUser((Entity)event.getPlayer());
        if (user != null && user.isFrozen()) {
            event.setCancelled(true);
            this.plugin.getEssentialsServer().sendMessage(user.getUniqueId(), Message.MESSAGE_FREEZE, new Object[0]);
        }
    }

    @Override
    public void cancelChatEvent(Cancellable event, Player player) {
        User user = this.getUser((Entity)player);
        if (user != null && user.isMute()) {
            event.setCancelled(true);
            Sanction sanction = user.getMuteSanction();
            Duration duration = sanction.getDurationRemaining();
            this.message((CommandSender)player, Message.MESSAGE_MUTE_TALK, "%reason%", sanction.getReason(), "%duration%", TimerBuilder.getStringTime(duration.toMillis()));
        }
    }
}

