/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.module.modules;

import fr.maxlego08.essentials.ZEssentialsPlugin;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.module.ZModule;
import fr.maxlego08.essentials.storage.ConfigStorage;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.spigotmc.event.player.PlayerSpawnLocationEvent;

public class SpawnModule
extends ZModule {
    private final String respawnListenerPriority = "normal";
    private final String spawnJoinListenerPriority = "normal";
    private boolean respawnAtAnchor;
    private boolean respawnAtHome;
    private boolean respawnAtBed;
    private boolean teleportAtSpawnOnJoin;

    public SpawnModule(ZEssentialsPlugin plugin) {
        super(plugin, "spawn");
    }

    @Override
    public void loadConfiguration() {
        super.loadConfiguration();
        if (!this.isEnable()) {
            return;
        }
        PluginManager pluginManager = Bukkit.getServer().getPluginManager();
        Objects.requireNonNull(this);
        EventPriority respawnPriority = this.getPriority("normal");
        HandlerList.unregisterAll((Listener)this);
        if (respawnPriority != null) {
            pluginManager.registerEvent(PlayerRespawnEvent.class, (Listener)this, respawnPriority, (listener, event) -> {
                if (listener instanceof SpawnModule) {
                    SpawnModule spawnModule = (SpawnModule)listener;
                    if (event instanceof PlayerRespawnEvent) {
                        PlayerRespawnEvent playerRespawnEvent = (PlayerRespawnEvent)event;
                        spawnModule.onRespawn(playerRespawnEvent, playerRespawnEvent.getPlayer());
                    }
                }
            }, (Plugin)this.plugin);
        }
        Objects.requireNonNull(this);
        EventPriority spawnPriority = this.getPriority("normal");
        pluginManager.registerEvent(PlayerSpawnLocationEvent.class, (Listener)this, spawnPriority, (listener, event) -> {
            if (listener instanceof SpawnModule) {
                SpawnModule spawnModule = (SpawnModule)listener;
                if (event instanceof PlayerSpawnLocationEvent) {
                    PlayerSpawnLocationEvent playerSpawnLocationEvent = (PlayerSpawnLocationEvent)event;
                    spawnModule.onSpawnLocation(playerSpawnLocationEvent, playerSpawnLocationEvent.getPlayer());
                }
            }
        }, (Plugin)this.plugin);
        if (this.plugin.isFolia()) {
            pluginManager.registerEvent(PlayerDeathEvent.class, (Listener)this, EventPriority.LOWEST, (listener, event) -> {
                if (listener instanceof SpawnModule) {
                    SpawnModule spawnModule = (SpawnModule)listener;
                    if (event instanceof PlayerDeathEvent) {
                        PlayerDeathEvent playerDeathEvent = (PlayerDeathEvent)event;
                        spawnModule.onPlayerDeath(playerDeathEvent, playerDeathEvent.getPlayer());
                    }
                }
            }, (Plugin)this.plugin);
        }
        if (this.teleportAtSpawnOnJoin) {
            pluginManager.registerEvent(PlayerJoinEvent.class, (Listener)this, EventPriority.LOWEST, (listener, event) -> {
                if (listener instanceof SpawnModule) {
                    SpawnModule spawnModule = (SpawnModule)listener;
                    if (event instanceof PlayerJoinEvent) {
                        PlayerJoinEvent playerJoinEvent = (PlayerJoinEvent)event;
                        Player player = playerJoinEvent.getPlayer();
                        if (ConfigStorage.spawnLocation != null && ConfigStorage.spawnLocation.isValid()) {
                            player.teleport(ConfigStorage.spawnLocation.getLocation());
                        }
                    }
                }
            }, (Plugin)this.plugin);
        }
    }

    private void onPlayerDeath(PlayerDeathEvent playerDeathEvent, Player player) {
        if (this.respawnAtBed) {
            // empty if block
        }
        if (this.respawnAtHome) {
            // empty if block
        }
        if (ConfigStorage.spawnLocation != null && ConfigStorage.spawnLocation.isValid()) {
            player.setRespawnLocation(ConfigStorage.spawnLocation.getLocation(), true);
        } else {
            this.message((CommandSender)player, Message.COMMAND_SPAWN_LOCATION_INVALID, new Object[0]);
        }
    }

    public void onSpawnLocation(PlayerSpawnLocationEvent event, Player player) {
        User user = this.getUser((Entity)player);
        if (user != null && user.isFirstJoin()) {
            if (ConfigStorage.firstSpawnLocation != null && ConfigStorage.firstSpawnLocation.isValid()) {
                event.setSpawnLocation(ConfigStorage.firstSpawnLocation.getLocation());
            } else if (ConfigStorage.spawnLocation != null && ConfigStorage.spawnLocation.isValid()) {
                event.setSpawnLocation(ConfigStorage.spawnLocation.getLocation());
            }
        }
    }

    private void onRespawn(PlayerRespawnEvent event, Player player) {
        Location respawnLocation;
        if (ConfigStorage.spawnLocation == null || !ConfigStorage.spawnLocation.isValid()) {
            return;
        }
        if (event.isAnchorSpawn() && this.respawnAtAnchor) {
            return;
        }
        if (this.respawnAtHome) {
            // empty if block
        }
        if (this.respawnAtBed && event.isBedSpawn() && (respawnLocation = player.getRespawnLocation()) != null) {
            event.setRespawnLocation(respawnLocation);
            return;
        }
        event.setRespawnLocation(ConfigStorage.spawnLocation.getLocation());
    }

    public void onPlayerFirstJoin(Player player) {
        if (!this.isEnable) {
            return;
        }
        if (ConfigStorage.firstSpawnLocation != null && ConfigStorage.firstSpawnLocation.isValid()) {
            player.teleport(ConfigStorage.firstSpawnLocation.getLocation());
        } else if (ConfigStorage.spawnLocation != null && ConfigStorage.spawnLocation.isValid()) {
            player.teleport(ConfigStorage.spawnLocation.getLocation());
        }
    }
}

