/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.module.modules.chat;

import fr.maxlego08.essentials.api.chat.ChatDisplay;
import fr.maxlego08.essentials.api.messages.MessageUtils;
import fr.maxlego08.essentials.api.utils.component.AdventureComponent;
import fr.maxlego08.essentials.zutils.utils.ZUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class CommandDisplay
extends ZUtils
implements ChatDisplay {
    private final Pattern pattern = Pattern.compile("\\./(.*?)(\\.|$)");
    private final String result;
    private final String permission;

    public CommandDisplay(String result, String permission) {
        this.result = result;
        this.permission = permission;
    }

    @Override
    public String display(AdventureComponent adventureComponent, TagResolver.Builder builder, Player sender, Player receiver, String message) {
        Matcher matcher = this.pattern.matcher(message);
        StringBuilder formattedMessage = new StringBuilder();
        while (matcher.find()) {
            String command = matcher.group(1);
            String placeholderTag = MessageUtils.removeNonAlphanumeric("cmd_" + command.replace(" ", "_")).toLowerCase();
            builder.resolver((TagResolver)Placeholder.component((String)placeholderTag, (ComponentLike)adventureComponent.getComponent(this.result.replace("%command%", command).replace("%fixed_command%", command.replace("'", "\\'")))));
            matcher.appendReplacement(formattedMessage, "<" + placeholderTag + ">");
        }
        matcher.appendTail(formattedMessage);
        return formattedMessage.toString();
    }

    @Override
    public boolean hasPermission(Permissible permissible) {
        return permissible.hasPermission(this.permission);
    }
}

