/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.module.modules.hologram;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.hologram.Hologram;
import fr.maxlego08.essentials.api.hologram.HologramLine;
import fr.maxlego08.essentials.api.hologram.HologramManager;
import fr.maxlego08.essentials.api.hologram.HologramType;
import fr.maxlego08.essentials.api.hologram.configuration.BlockHologramConfiguration;
import fr.maxlego08.essentials.api.hologram.configuration.HologramConfiguration;
import fr.maxlego08.essentials.api.hologram.configuration.ItemHologramConfiguration;
import fr.maxlego08.essentials.api.hologram.configuration.TextHologramConfiguration;
import fr.maxlego08.essentials.api.utils.SafeLocation;
import fr.maxlego08.essentials.zutils.utils.ZUtils;
import fr.maxlego08.menu.api.exceptions.InventoryException;
import fr.maxlego08.menu.api.utils.Loader;
import fr.maxlego08.menu.zcore.utils.nms.ItemStackUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Display;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.joml.Vector3f;

public class HologramLoader
extends ZUtils
implements Loader<Hologram> {
    private final EssentialsPlugin plugin;

    public HologramLoader(EssentialsPlugin plugin) {
        this.plugin = plugin;
    }

    public Hologram load(YamlConfiguration configuration, String path, Object ... objects) throws InventoryException {
        HologramType hologramType = HologramType.valueOf(configuration.getString("type"));
        String name = configuration.getString("name");
        SafeLocation location = this.stringAsLocation(configuration.getString("location"));
        BlockHologramConfiguration hologramConfiguration = hologramType == HologramType.BLOCK ? new BlockHologramConfiguration() : (hologramType == HologramType.ITEM ? new ItemHologramConfiguration() : new TextHologramConfiguration());
        HologramManager hologramManager = this.plugin.getHologramManager();
        Hologram hologram = hologramManager.createHologram(hologramType, hologramConfiguration, (String)objects[0], name, location);
        this.loadConfiguration(configuration, hologramConfiguration);
        switch (hologramType) {
            case TEXT: {
                this.loadTextConfiguration(hologram, configuration, (TextHologramConfiguration)((Object)hologramConfiguration));
                break;
            }
            case BLOCK: {
                this.loadBlockConfiguration(configuration, hologramConfiguration);
                break;
            }
            case ITEM: {
                this.loadItemConfiguration(configuration, (ItemHologramConfiguration)((Object)hologramConfiguration));
            }
        }
        return hologram;
    }

    private void loadConfiguration(YamlConfiguration configuration, HologramConfiguration hologramConfiguration) {
        hologramConfiguration.setTranslation(this.loadVector(configuration, "translation."));
        hologramConfiguration.setScale(this.loadVector(configuration, "scale."));
        hologramConfiguration.setBillboard(Display.Billboard.valueOf((String)configuration.getString("bill-board")));
        hologramConfiguration.setShadowRadius((float)configuration.getDouble("shadow-radius"));
        hologramConfiguration.setShadowStrength((float)configuration.getDouble("shadow-strength"));
        hologramConfiguration.setVisibilityDistance(configuration.getInt("visibility-distance"));
        ConfigurationSection configurationSection = configuration.getConfigurationSection("brightness");
        if (configurationSection != null) {
            hologramConfiguration.setBrightness(new Display.Brightness(configurationSection.getInt("block"), configurationSection.getInt("sky")));
        }
    }

    private void loadItemConfiguration(YamlConfiguration configuration, ItemHologramConfiguration itemHologramConfiguration) {
        itemHologramConfiguration.setItemStack(ItemStackUtils.deserializeItemStack((String)configuration.getString("itemstack", "null")));
    }

    private void loadBlockConfiguration(YamlConfiguration configuration, BlockHologramConfiguration blockHologramConfiguration) {
        blockHologramConfiguration.setMaterial(Material.valueOf((String)configuration.getString("block-material", "GRASS_BLOCK").toUpperCase()));
    }

    private void loadTextConfiguration(Hologram hologram, YamlConfiguration configuration, TextHologramConfiguration textHologramConfiguration) {
        textHologramConfiguration.setTextShadow(configuration.getBoolean("text-shadow"));
        textHologramConfiguration.setTextAlignment(TextDisplay.TextAlignment.valueOf((String)configuration.getString("text-alignment")));
        textHologramConfiguration.setSeeThrough(configuration.getBoolean("see-through"));
        textHologramConfiguration.setBackground(this.configureBackground(configuration));
        configuration.getMapList("lines").forEach(map -> {
            String text = (String)map.get("text");
            int line = ((Number)map.get("line")).intValue();
            String eventName = map.containsKey("event") ? (String)map.get("event") : null;
            boolean isAutoUpdate = map.containsKey("update") && (Boolean)map.get("update") != false;
            hologram.addLine(new HologramLine(line, text, eventName, isAutoUpdate));
        });
    }

    public void save(Hologram hologram, YamlConfiguration configuration, String path, File file, Object ... objects) {
        configuration.set("type", (Object)hologram.getHologramType().name());
        configuration.set("name", (Object)hologram.getName());
        configuration.set("location", (Object)this.locationAsString(hologram.getLocation()));
        HologramConfiguration hologramConfiguration = hologram.getConfiguration();
        configuration.set("bill-board", (Object)hologramConfiguration.getBillboard().name());
        configuration.set("shadow-radius", (Object)Float.valueOf(hologramConfiguration.getShadowRadius()));
        configuration.set("shadow-strength", (Object)Float.valueOf(hologramConfiguration.getShadowStrength()));
        configuration.set("visibility-distance", (Object)hologramConfiguration.getVisibilityDistance());
        Display.Brightness brightness = hologramConfiguration.getBrightness();
        if (brightness != null) {
            configuration.set("brightness.block", (Object)brightness.getBlockLight());
            configuration.set("brightness.sky", (Object)brightness.getSkyLight());
        }
        this.setVector(configuration, "scale.", hologramConfiguration.getScale());
        this.setVector(configuration, "translation.", hologramConfiguration.getTranslation());
        if (hologramConfiguration instanceof TextHologramConfiguration) {
            TextHologramConfiguration textHologramConfiguration = (TextHologramConfiguration)hologramConfiguration;
            configuration.set("text-alignment", (Object)textHologramConfiguration.getTextAlignment().name());
            configuration.set("text-shadow", (Object)textHologramConfiguration.isTextShadow());
            configuration.set("text-background", (Object)this.getColor(textHologramConfiguration));
            configuration.set("see-through", (Object)textHologramConfiguration.isSeeThrough());
            ArrayList lines = new ArrayList();
            hologram.getHologramLines().stream().sorted(Comparator.comparingInt(HologramLine::getLine)).forEach(hologramLine -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("line", hologramLine.getLine());
                map.put("text", hologramLine.getText());
                if (hologramLine.getEventName() != null) {
                    map.put("event", hologramLine.getEventName());
                }
                lines.add(map);
            });
            configuration.set("lines", lines);
        } else if (hologramConfiguration instanceof BlockHologramConfiguration) {
            BlockHologramConfiguration blockHologramConfiguration = (BlockHologramConfiguration)hologramConfiguration;
            configuration.set("block-material", (Object)blockHologramConfiguration.getMaterial().name());
        } else if (hologramConfiguration instanceof ItemHologramConfiguration) {
            ItemHologramConfiguration itemHologramConfiguration = (ItemHologramConfiguration)hologramConfiguration;
            configuration.set("itemstack", (Object)ItemStackUtils.serializeItemStack((ItemStack)itemHologramConfiguration.getItemStack()));
        }
    }

    public void setVector(YamlConfiguration configuration, String path, Vector3f vector3f) {
        configuration.set(path + "x", (Object)Float.valueOf(vector3f.x()));
        configuration.set(path + "y", (Object)Float.valueOf(vector3f.y()));
        configuration.set(path + "z", (Object)Float.valueOf(vector3f.z()));
    }

    public Vector3f loadVector(YamlConfiguration configuration, String path) {
        return new Vector3f((float)configuration.getDouble(path + "x"), (float)configuration.getDouble(path + "y"), (float)configuration.getDouble(path + "z"));
    }

    public String getColor(TextHologramConfiguration textHologramConfiguration) {
        TextColor background = textHologramConfiguration.getBackground();
        return Optional.ofNullable(background).map(bg -> {
            String string;
            if (bg == Hologram.TRANSPARENT) {
                string = "transparent";
            } else if (bg instanceof NamedTextColor) {
                NamedTextColor named = (NamedTextColor)bg;
                string = named.toString();
            } else {
                string = bg.asHexString();
            }
            return string;
        }).orElse("default");
    }

    public TextColor configureBackground(YamlConfiguration configuration) {
        String backgroundStr = configuration.getString("text-background", null);
        if (backgroundStr == null || backgroundStr.equalsIgnoreCase("default")) {
            return null;
        }
        if (backgroundStr.equalsIgnoreCase("transparent")) {
            return Hologram.TRANSPARENT;
        }
        if (backgroundStr.startsWith("#")) {
            return TextColor.fromHexString((String)backgroundStr);
        }
        String formattedName = backgroundStr.toLowerCase(Locale.ROOT).trim().replace(' ', '_');
        return (TextColor)NamedTextColor.NAMES.value((Object)formattedName);
    }
}

