/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.module.modules.scoreboard;

import fr.maxlego08.essentials.ZEssentialsPlugin;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.scoreboard.EssentialsScoreboard;
import fr.maxlego08.essentials.api.scoreboard.JoinCondition;
import fr.maxlego08.essentials.api.scoreboard.PlayerBoard;
import fr.maxlego08.essentials.api.scoreboard.ScoreboardLine;
import fr.maxlego08.essentials.api.scoreboard.ScoreboardManager;
import fr.maxlego08.essentials.api.scoreboard.TaskCondition;
import fr.maxlego08.essentials.api.user.Option;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.libs.fastboard.FastBoardBase;
import fr.maxlego08.essentials.libs.folialib.wrapper.task.WrappedTask;
import fr.maxlego08.essentials.module.ZModule;
import fr.maxlego08.essentials.module.modules.scoreboard.ZEssentialsScoreboard;
import fr.maxlego08.essentials.module.modules.scoreboard.board.ClassicBoard;
import fr.maxlego08.essentials.module.modules.scoreboard.board.ComponentBoard;
import fr.maxlego08.menu.api.ButtonManager;
import fr.maxlego08.menu.api.engine.InventoryEngine;
import fr.maxlego08.menu.api.requirement.Permissible;
import fr.maxlego08.menu.api.utils.Placeholders;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class ScoreboardModule
extends ZModule
implements ScoreboardManager {
    private final List<EssentialsScoreboard> essentialsScoreboards = new ArrayList<EssentialsScoreboard>();
    private final Map<UUID, PlayerBoard> boards = new HashMap<UUID, PlayerBoard>();
    private final List<JoinCondition> joinConditions = new ArrayList<JoinCondition>();
    private final List<TaskCondition> taskConditions = new ArrayList<TaskCondition>();
    private boolean enableTaskConditions;
    private int taskConditionsInterval;
    private EssentialsScoreboard defaultScoreboard;
    private WrappedTask wrappedTask;

    public ScoreboardModule(ZEssentialsPlugin plugin) {
        super(plugin, "scoreboard");
        this.isRegisterEvent = false;
    }

    @Override
    public void loadConfiguration() {
        YamlConfiguration configuration;
        ConfigurationSection configurationSection;
        super.loadConfiguration();
        if (this.wrappedTask != null) {
            this.wrappedTask.cancel();
        }
        if ((configurationSection = (configuration = this.getConfiguration()).getConfigurationSection("scoreboards")) == null) {
            return;
        }
        configurationSection.getKeys(false).forEach(scoreboardName -> {
            ConfigurationSection section = configurationSection.getConfigurationSection(scoreboardName);
            if (section == null) {
                return;
            }
            ZEssentialsScoreboard essentialsScoreboard = new ZEssentialsScoreboard((String)scoreboardName, section);
            if (essentialsScoreboard.isDefault()) {
                this.defaultScoreboard = essentialsScoreboard;
            }
            this.essentialsScoreboards.add(essentialsScoreboard);
        });
        this.loadJoinConditions(configuration);
        this.loadTaskConditions(configuration);
        HandlerList.unregisterAll((Listener)this);
        if (this.isEnable()) {
            this.reloadPlayers();
            this.registerEvents();
        }
        if (this.enableTaskConditions) {
            this.wrappedTask = this.plugin.getScheduler().runTimer(this::updateScoreboards, (long)this.taskConditionsInterval, (long)this.taskConditionsInterval, TimeUnit.SECONDS);
        }
    }

    private void loadJoinConditions(YamlConfiguration configuration) {
        this.joinConditions.clear();
        ButtonManager manager = this.plugin.getButtonManager();
        List mapList = configuration.getMapList("join-conditions");
        mapList.forEach(map -> {
            int priority = ((Number)map.get("priority")).intValue();
            String scoreboard = (String)map.get("scoreboard");
            List mapPermissibles = (List)map.get("requirements");
            ArrayList<Permissible> permissibles = mapPermissibles == null ? new ArrayList<Permissible>() : manager.loadPermissible(mapPermissibles, "join-conditions", new File(this.getFolder(), "config.yml"));
            this.joinConditions.add(new JoinCondition(priority, scoreboard, permissibles));
        });
    }

    private void loadTaskConditions(YamlConfiguration configuration) {
        this.taskConditions.clear();
        ButtonManager manager = this.plugin.getButtonManager();
        List mapList = configuration.getMapList("task-conditions");
        mapList.forEach(map -> {
            String scoreboard = (String)map.get("scoreboard");
            List mapPermissibles = (List)map.get("requirements");
            ArrayList<Permissible> permissibles = mapPermissibles == null ? new ArrayList<Permissible>() : manager.loadPermissible(mapPermissibles, "task-conditions", new File(this.getFolder(), "config.yml"));
            this.taskConditions.add(new TaskCondition(scoreboard, permissibles));
        });
    }

    private void registerEvents() {
        PluginManager pluginManager = Bukkit.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)this, (Plugin)this.plugin);
        List<String> events = this.essentialsScoreboards.stream().map(EssentialsScoreboard::getLines).flatMap(Collection::stream).map(ScoreboardLine::getEventName).filter(Objects::nonNull).distinct().toList();
        this.registerEvents(events);
    }

    @Override
    protected void updateEventPlayer(Player player, String eventName) {
        if (this.boards.containsKey(player.getUniqueId())) {
            PlayerBoard board = this.boards.get(player.getUniqueId());
            this.updatePlayerBoard(board, eventName);
        }
    }

    @Override
    protected void updateEventUniqueId(UUID uniqueId, String eventName) {
        if (this.boards.containsKey(uniqueId)) {
            PlayerBoard board = this.boards.get(uniqueId);
            this.updatePlayerBoard(board, eventName);
        }
    }

    private void updatePlayerBoard(PlayerBoard board, String eventName) {
        this.plugin.getScheduler().runNextTick(wrappedTask -> board.getScoreboard().update(board, eventName));
    }

    @Override
    public void reloadPlayers() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            PlayerBoard board = this.boards.remove(player.getUniqueId());
            if (board == null) continue;
            board.delete();
            Optional<EssentialsScoreboard> optional = this.getScoreboard(board.getScoreboard().getName());
            optional.ifPresent(essentialsScoreboard -> this.createScoreboard(player, (EssentialsScoreboard)essentialsScoreboard));
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        if (this.defaultScoreboard == null) {
            return;
        }
        User user = this.plugin.getUser(event.getPlayer().getUniqueId());
        if (user != null && user.getOption(Option.DISABLE_SCOREBOARD)) {
            return;
        }
        Player player = event.getPlayer();
        EssentialsScoreboard essentialsScoreboard = this.getJoinScoreboard(player);
        this.createScoreboard(player, essentialsScoreboard);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.deleteBoard(event.getPlayer());
    }

    @Override
    public PlayerBoard createScoreboard(Player player, EssentialsScoreboard essentialsScoreboard) {
        FastBoardBase playerBoard = this.plugin.isPaperVersion() ? new ComponentBoard(player, essentialsScoreboard) : new ClassicBoard(player, essentialsScoreboard);
        this.boards.put(player.getUniqueId(), (PlayerBoard)((Object)playerBoard));
        essentialsScoreboard.create((PlayerBoard)((Object)playerBoard));
        return playerBoard;
    }

    @Override
    public void deleteBoard(Player player) {
        PlayerBoard board = this.boards.remove(player.getUniqueId());
        if (board != null) {
            board.delete();
        }
    }

    @Override
    public Optional<PlayerBoard> getBoard(Player player) {
        return Optional.ofNullable(this.boards.get(player.getUniqueId()));
    }

    @Override
    public List<EssentialsScoreboard> getEssentialsScoreboard() {
        return this.essentialsScoreboards;
    }

    @Override
    public EssentialsScoreboard getDefaultScoreboard() {
        return this.defaultScoreboard;
    }

    @Override
    public Optional<EssentialsScoreboard> getScoreboard(String name) {
        return this.essentialsScoreboards.stream().filter(essentialsScoreboard -> essentialsScoreboard.getName().equalsIgnoreCase(name)).findFirst();
    }

    @Override
    public void toggleScoreboard(Player player, boolean silent) {
        User user = this.plugin.getUser(player.getUniqueId());
        if (this.boards.containsKey(player.getUniqueId())) {
            if (user != null) {
                user.setOption(Option.DISABLE_SCOREBOARD, true);
            }
            this.deleteBoard(player);
            if (!silent) {
                this.message((CommandSender)player, Message.SCOREBOARD_DISABLE, new Object[0]);
            }
        } else {
            if (user != null) {
                user.setOption(Option.DISABLE_SCOREBOARD, false);
            }
            this.createScoreboard(player, this.getJoinScoreboard(player));
            if (!silent) {
                this.message((CommandSender)player, Message.SCOREBOARD_ENABLE, new Object[0]);
            }
        }
    }

    @Override
    public EssentialsScoreboard getJoinScoreboard(Player player) {
        InventoryEngine fakeInventory = this.plugin.getInventoryManager().getFakeInventory();
        return this.joinConditions.stream().sorted(Comparator.comparingInt(JoinCondition::priority).reversed()).filter(joinCondition -> joinCondition.permissibles().isEmpty() || joinCondition.permissibles().stream().allMatch(permissible -> permissible.hasPermission(player, null, fakeInventory, new Placeholders()))).map(joinCondition -> this.getScoreboard(joinCondition.scoreboard())).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(this.defaultScoreboard);
    }

    @Override
    public EssentialsScoreboard getTaskScoreboard(Player player) {
        InventoryEngine fakeInventory = this.plugin.getInventoryManager().getFakeInventory();
        return this.taskConditions.stream().filter(taskCondition -> taskCondition.permissibles().isEmpty() || taskCondition.permissibles().stream().allMatch(permissible -> permissible.hasPermission(player, null, fakeInventory, new Placeholders()))).map(joinCondition -> this.getScoreboard(joinCondition.scoreboard())).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(this.defaultScoreboard);
    }

    private void updateScoreboards() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            User user = this.plugin.getUser(player.getUniqueId());
            if (user != null && user.getOption(Option.DISABLE_SCOREBOARD)) {
                return;
            }
            this.getBoard(player).ifPresent(playerBoard -> {
                EssentialsScoreboard essentialsScoreboard = this.getTaskScoreboard(player);
                if (playerBoard.getScoreboard() != essentialsScoreboard) {
                    this.deleteBoard(player);
                    this.createScoreboard(player, essentialsScoreboard);
                }
            });
        }
    }

    @Override
    public void update(Player player) {
        User user = this.plugin.getUser(player.getUniqueId());
        if (user != null && user.getOption(Option.DISABLE_SCOREBOARD)) {
            return;
        }
        this.getBoard(player).ifPresent(playerBoard -> {
            EssentialsScoreboard essentialsScoreboard = this.getTaskScoreboard(player);
            essentialsScoreboard.update((PlayerBoard)playerBoard);
        });
    }
}

