/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.module.modules.scoreboard.animation;

import fr.maxlego08.essentials.api.scoreboard.PlayerBoard;
import fr.maxlego08.essentials.api.scoreboard.ScoreboardAnimation;
import fr.maxlego08.essentials.api.scoreboard.configurations.ColorWaveConfiguration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ColorWaveAnimation
extends ScoreboardAnimation {
    private final String text;
    private final ColorWaveConfiguration configuration;

    public ColorWaveAnimation(PlayerBoard playerBoard, String text, int line, ColorWaveConfiguration configuration) {
        super(playerBoard, line);
        this.text = text;
        this.configuration = configuration;
    }

    @Override
    public void start() {
        this.playerBoard.updateLine(this.playerBoard.getLineModifier(this.line), this.configuration.fromColor() + this.text);
        EXECUTOR_SERVICE.schedule(this::animation, (long)this.configuration.delayBetween(), TimeUnit.MILLISECONDS);
    }

    private void animation() {
        if (this.playerBoard.isDeleted()) {
            return;
        }
        AtomicInteger atomicInteger = new AtomicInteger(-this.configuration.length());
        this.future = EXECUTOR_SERVICE.scheduleAtFixedRate(() -> {
            if (this.playerBoard.isDeleted()) {
                this.future.cancel(false);
                return;
            }
            int step = atomicInteger.getAndIncrement();
            this.playerBoard.updateLine(this.playerBoard.getLineModifier(this.line), this.getAnimatedText(this.text, this.configuration.toColor(), this.configuration.fromColor(), step));
            if (step > this.text.length() + this.configuration.length()) {
                this.playerBoard.updateLine(this.playerBoard.getLineModifier(this.line), this.configuration.fromColor() + this.text);
                EXECUTOR_SERVICE.schedule(this::animation, (long)this.configuration.delayBetween(), TimeUnit.MILLISECONDS);
                this.future.cancel(false);
            }
        }, 0L, this.configuration.animationSpeed(), TimeUnit.MILLISECONDS);
    }

    private String getAnimatedText(String text, String baseColorHex, String highlightColorHex, int highlightIndex) {
        StringBuilder animatedText = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            String colorHex = this.blendColors(baseColorHex, highlightColorHex, i, highlightIndex, this.configuration.length());
            if (colorHex.length() > 7) {
                colorHex = this.configuration.fromColor();
            }
            animatedText.append(colorHex).append(text.charAt(i));
        }
        return animatedText.toString();
    }
}

