/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.module.modules.vault;

import fr.maxlego08.essentials.ZEssentialsPlugin;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.dto.PlayerSlotDTO;
import fr.maxlego08.essentials.api.dto.VaultDTO;
import fr.maxlego08.essentials.api.dto.VaultItemDTO;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.storage.IStorage;
import fr.maxlego08.essentials.api.vault.PermissionSlotsVault;
import fr.maxlego08.essentials.api.vault.PlayerVaults;
import fr.maxlego08.essentials.api.vault.Vault;
import fr.maxlego08.essentials.api.vault.VaultItem;
import fr.maxlego08.essentials.api.vault.VaultManager;
import fr.maxlego08.essentials.api.vault.VaultResult;
import fr.maxlego08.essentials.api.vault.VaultSlotType;
import fr.maxlego08.essentials.module.ZModule;
import fr.maxlego08.essentials.module.modules.vault.ZPlayerVaults;
import fr.maxlego08.essentials.module.modules.vault.ZVault;
import fr.maxlego08.essentials.module.modules.vault.ZVaultItem;
import fr.maxlego08.menu.zcore.utils.nms.ItemStackUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;

public class VaultModule
extends ZModule
implements VaultManager {
    private final Map<UUID, PlayerVaults> vaults = new HashMap<UUID, PlayerVaults>();
    private int maxVaults;
    private String iconOpen;
    private String iconClose;
    private int iconOpenModelId;
    private int iconCloseModelId;
    private String vaultNameRegex;
    private String defaultVaultName;
    private List<PermissionSlotsVault> vaultPermissions;
    private VaultSlotType vaultSlotType = VaultSlotType.MAX;

    public VaultModule(ZEssentialsPlugin plugin) {
        super(plugin, "vault");
    }

    @Override
    public void loadConfiguration() {
        super.loadConfiguration();
        this.loadInventory("vault");
        this.loadInventory("vault-configuration");
        this.loadInventory("vault-admin");
    }

    @Override
    public void loadVaults() {
        IStorage storage = this.getStorage();
        List<VaultDTO> vaultDTOS = storage.getVaults();
        List<VaultItemDTO> vaultItemDTOS = storage.getVaultItems();
        List<PlayerSlotDTO> slotDTOS = storage.getPlayerVaultSlots();
        vaultDTOS.forEach(vaultDTO -> {
            PlayerVaults playerVaults = this.vaults.computeIfAbsent(vaultDTO.unique_id(), uniqueId -> new ZPlayerVaults(this, (UUID)uniqueId));
            playerVaults.createVault((VaultDTO)vaultDTO);
        });
        vaultItemDTOS.forEach(vaultItemDTO -> {
            PlayerVaults playerVaults = this.vaults.computeIfAbsent(vaultItemDTO.unique_id(), uniqueId -> new ZPlayerVaults(this, (UUID)uniqueId));
            Vault vault = playerVaults.getVaults().computeIfAbsent(vaultItemDTO.vault_id(), id -> new ZVault(vaultItemDTO.unique_id(), (int)id, this.defaultVaultName));
            vault.createItem((VaultItemDTO)vaultItemDTO);
        });
        slotDTOS.forEach(playerSlotDTO -> {
            PlayerVaults playerVaults = this.vaults.computeIfAbsent(playerSlotDTO.unique_id(), uniqueId -> new ZPlayerVaults(this, (UUID)uniqueId));
            playerVaults.setSlots(playerSlotDTO.slots());
        });
    }

    @Override
    public void openVault(Player player, int vaultId) {
        if (vaultId < 1 || vaultId > this.maxVaults) {
            this.message((CommandSender)player, Message.COMMAND_VAULT_NOT_FOUND, "%vaultId%", vaultId);
            return;
        }
        if (!this.hasPermission(player.getUniqueId(), vaultId)) {
            this.message((CommandSender)player, Message.COMMAND_VAULT_NO_PERMISSION, new Object[0]);
            return;
        }
        PlayerVaults playerVaults = this.getPlayerVaults((OfflinePlayer)player);
        Vault vault = playerVaults.getVault(vaultId);
        playerVaults.setTargetVault(vault);
        playerVaults.setTargetPlayerVaults(playerVaults);
        this.plugin.openInventory(player, "vault");
    }

    @Override
    public void openVault(Player player, OfflinePlayer target, int vaultId) {
        if (vaultId < 1 || vaultId > this.maxVaults) {
            this.message((CommandSender)player, Message.COMMAND_VAULT_NOT_FOUND, "%vaultId%", vaultId);
            return;
        }
        if (!this.hasPermission(target.getUniqueId(), vaultId)) {
            this.message((CommandSender)player, Message.COMMAND_VAULT_NO_PERMISSION, new Object[0]);
            return;
        }
        PlayerVaults targetVaults = this.getPlayerVaults(target);
        Vault vault = targetVaults.getVault(vaultId);
        PlayerVaults viewerVaults = this.getPlayerVaults((OfflinePlayer)player);
        viewerVaults.setTargetVault(vault);
        viewerVaults.setTargetPlayerVaults(targetVaults);
        this.plugin.openInventory(player, "vault-admin");
    }

    @Override
    public PlayerVaults getPlayerVaults(OfflinePlayer offlinePlayer) {
        return this.getPlayerVaults(offlinePlayer.getUniqueId());
    }

    @Override
    public PlayerVaults getPlayerVaults(UUID uniqueId) {
        return this.vaults.computeIfAbsent(uniqueId, uniqueId1 -> new ZPlayerVaults(this, (UUID)uniqueId1));
    }

    @Override
    public void setPlayerSlot(CommandSender sender, OfflinePlayer offlinePlayer, int slot) {
        PlayerVaults playerVaults = this.getPlayerVaults(offlinePlayer);
        playerVaults.setSlots(slot);
        this.getStorage().setVaultSlot(offlinePlayer.getUniqueId(), slot);
        this.message(sender, Message.COMMAND_VAULT_SET_SLOT, "%player%", offlinePlayer.getName(), "%slots%", slot);
    }

    @Override
    public int getMaxSlotsPlayer(Player player) {
        int playerVaultSlot = this.getPlayerVaults(player.getUniqueId()).getSlots();
        int permissionSlot = this.vaultPermissions.stream().filter(permission -> player.hasPermission(permission.permission())).mapToInt(PermissionSlotsVault::slots).max().orElse(0);
        return this.vaultSlotType == null || this.vaultSlotType == VaultSlotType.MAX ? Math.max(playerVaultSlot, permissionSlot) : playerVaultSlot + permissionSlot;
    }

    @Override
    public void addPlayerSlot(CommandSender sender, OfflinePlayer offlinePlayer, int slot) {
        PlayerVaults playerVaults = this.getPlayerVaults(offlinePlayer);
        playerVaults.setSlots(playerVaults.getSlots() + slot);
        this.getStorage().setVaultSlot(offlinePlayer.getUniqueId(), playerVaults.getSlots());
        this.message(sender, Message.COMMAND_VAULT_ADD_SLOT, "%player%", offlinePlayer.getName(), "%amount%", slot);
    }

    @Override
    public VaultResult addVaultItem(Vault vault, UUID uniqueId, ItemStack currentItem, int slot, int quantity, int size) {
        VaultItem vaultItem;
        PlayerVaults playerVault = this.getPlayerVaults(uniqueId);
        if (slot != -1 && (vaultItem = vault.getVaultItems().get(slot)) != null && vaultItem.getItemStack().isSimilar(currentItem)) {
            return this.updateVaultItemQuantity(vault, uniqueId, vaultItem, quantity);
        }
        Optional<Vault> optionalVault = playerVault.find(currentItem);
        if (optionalVault.isPresent()) {
            return this.updateExistingVaultItem(optionalVault.get(), uniqueId, currentItem, quantity);
        }
        Player player = Bukkit.getPlayer((UUID)uniqueId);
        int totalSlots = player == null ? 999 : this.getMaxSlotsPlayer(player);
        return this.addNewItemToVault(vault, uniqueId, currentItem, quantity, size, totalSlots, slot);
    }

    @Override
    public VaultResult updateVaultItemQuantity(Vault vault, UUID uniqueId, VaultItem vaultItem, int quantity) {
        vaultItem.addQuantity(quantity);
        this.getStorage().updateVaultQuantity(uniqueId, vault.getVaultId(), vaultItem.getSlot(), vaultItem.getQuantity());
        return new VaultResult(vault, vaultItem.getSlot());
    }

    @Override
    public VaultResult updateExistingVaultItem(Vault currentVault, UUID uniqueId, ItemStack currentItem, int quantity) {
        Optional<VaultItem> optionalVaultItem = currentVault.find(currentItem);
        if (optionalVaultItem.isPresent()) {
            VaultItem currentVaultItem = optionalVaultItem.get();
            currentVaultItem.addQuantity(quantity);
            this.getStorage().updateVaultQuantity(uniqueId, currentVault.getVaultId(), currentVaultItem.getSlot(), currentVaultItem.getQuantity());
            return new VaultResult(currentVault, currentVaultItem.getSlot());
        }
        return null;
    }

    @Override
    public VaultResult addNewItemToVault(Vault vault, UUID uniqueId, ItemStack currentItem, int quantity, int size, int totalSlots, int slot) {
        int nextSlot = vault.getNextSlot() + (vault.getVaultId() - 1) * size;
        if (nextSlot == -1 || nextSlot >= totalSlots) {
            return null;
        }
        if (slot == -1) {
            slot = vault.getNextSlot();
        }
        ZVaultItem newVaultItem = new ZVaultItem(slot, currentItem, quantity);
        vault.getVaultItems().put(slot, newVaultItem);
        int finalSlot = slot;
        this.getStorage().createVaultItem(uniqueId, vault.getVaultId(), finalSlot, newVaultItem.getQuantity(), ItemStackUtils.serializeItemStack((ItemStack)currentItem));
        return new VaultResult(vault, slot);
    }

    @Override
    public void remove(Vault vault, VaultItem vaultItem, Player player, long amount, int slot) {
        if (!vault.contains(slot)) {
            return;
        }
        int freespace = 0;
        ItemStack itemStack = vaultItem.getItemStack();
        for (int invSlot = 0; invSlot <= 35; ++invSlot) {
            ItemStack invItem = player.getInventory().getItem(invSlot);
            if (invItem == null) {
                freespace += itemStack.getMaxStackSize();
                continue;
            }
            if (!invItem.isSimilar(itemStack)) continue;
            freespace += Math.max(0, itemStack.getMaxStackSize() - invItem.getAmount());
        }
        amount = amount == -1L ? Math.min((long)freespace, vaultItem.getQuantity()) : Math.min(Math.min(amount, vaultItem.getQuantity()), (long)freespace);
        long total = amount / (long)itemStack.getMaxStackSize();
        for (long i = 0L; i < total; ++i) {
            player.getInventory().addItem(new ItemStack[]{itemStack.asQuantity(itemStack.getMaxStackSize())});
        }
        player.getInventory().addItem(new ItemStack[]{itemStack.asQuantity((int)(amount - total * (long)itemStack.getMaxStackSize()))});
        IStorage storage = this.getStorage();
        if (vaultItem.getQuantity() > amount) {
            vaultItem.removeQuantity(amount);
            storage.updateVaultQuantity(vault.getUniqueId(), vault.getVaultId(), vaultItem.getSlot(), vaultItem.getQuantity());
        } else {
            vault.getVaultItems().remove(slot);
            storage.removeVaultItem(vault.getUniqueId(), vault.getVaultId(), vaultItem.getSlot());
        }
    }

    @Override
    public String getIconOpen() {
        return this.iconOpen;
    }

    @Override
    public String getIconClose() {
        return this.iconClose;
    }

    @Override
    public int getIconOpenModelId() {
        return this.iconOpenModelId;
    }

    @Override
    public int getIconCloseModelId() {
        return this.iconCloseModelId;
    }

    @Override
    public boolean hasPermission(UUID uniqueId, int vaultId) {
        PlayerVaults playerVaults = this.getPlayerVaults(uniqueId);
        Player player = Bukkit.getPlayer((UUID)uniqueId);
        return (player == null ? playerVaults.getSlots() : this.getMaxSlotsPlayer(player)) > vaultId * 45 - 45;
    }

    @Override
    public List<String> getVaultAsTabCompletion(Player player) {
        List<String> strings = IntStream.range(1, this.maxVaults).filter(vaultID -> this.hasPermission(player.getUniqueId(), vaultID)).mapToObj(String::valueOf).collect(Collectors.toList());
        if (this.hasPermission((Permissible)player, Permission.ESSENTIALS_VAULT_ADD_SLOT)) {
            strings.add("add");
        }
        if (this.hasPermission((Permissible)player, Permission.ESSENTIALS_VAULT_SET_SLOT)) {
            strings.add("set");
        }
        if (this.hasPermission((Permissible)player, Permission.ESSENTIALS_VAULT_GIVE)) {
            strings.add("give");
        }
        if (this.hasPermission((Permissible)player, Permission.ESSENTIALS_VAULT_INFO)) {
            strings.add("info");
        }
        if (this.hasPermission((Permissible)player, Permission.ESSENTIALS_VAULT_SHOW)) {
            strings.add("show");
        }
        return strings;
    }

    @Override
    public void openConfiguration(Player player, int vaultId) {
        if (vaultId < 1 || vaultId > this.maxVaults) {
            this.message((CommandSender)player, Message.COMMAND_VAULT_NOT_FOUND, "%vaultId%", vaultId);
            return;
        }
        if (!this.hasPermission(player.getUniqueId(), vaultId)) {
            this.message((CommandSender)player, Message.COMMAND_VAULT_NO_PERMISSION, new Object[0]);
            return;
        }
        PlayerVaults playerVaults = this.getPlayerVaults((OfflinePlayer)player);
        Vault vault = playerVaults.getVault(vaultId);
        playerVaults.setTargetVault(vault);
        playerVaults.setTargetPlayerVaults(playerVaults);
        this.plugin.openInventory(player, "vault-configuration");
    }

    @Override
    public void changeIcon(Player player, Vault vault) {
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        if (itemStack.getType().isAir()) {
            this.message((CommandSender)player, Message.COMMAND_VAULT_CHANGE_ICON_ERROR, new Object[0]);
            return;
        }
        vault.setIconItemStack(itemStack.clone());
        this.getStorage().updateVault(player.getUniqueId(), vault);
        this.message((CommandSender)player, Message.COMMAND_VAULT_CHANGE_ICON_SUCCESS, new Object[0]);
        this.openVault(player, vault.getVaultId());
    }

    @Override
    public void resetIcon(Player player, Vault vault) {
        vault.setIconItemStack(null);
        this.getStorage().updateVault(player.getUniqueId(), vault);
        this.message((CommandSender)player, Message.COMMAND_VAULT_RESET_ICON, new Object[0]);
        this.openVault(player, vault.getVaultId());
    }

    @Override
    public void changeName(Player player, Vault vault) {
        this.plugin.startInteractiveChat(player, message -> {
            Pattern pattern = Pattern.compile(this.vaultNameRegex == null ? "^[a-zA-Z0-9_-]{3,16}$" : this.vaultNameRegex);
            Matcher matcher = pattern.matcher((CharSequence)message);
            if (matcher.matches()) {
                vault.setName((String)message);
                this.getStorage().updateVault(player.getUniqueId(), vault);
                this.message((CommandSender)player, Message.COMMAND_VAULT_RENAME_SUCCESS, "%name%", message);
            } else {
                this.message((CommandSender)player, Message.COMMAND_VAULT_RENAME_ERROR, new Object[0]);
            }
            this.openVault(player, vault.getVaultId());
        }, System.currentTimeMillis() + 60000L);
        player.closeInventory();
        this.message((CommandSender)player, Message.COMMAND_VAULT_RENAME_START, new Object[0]);
    }

    @Override
    public void resetName(Player player, Vault vault) {
        vault.setName(this.defaultVaultName.replace("%vault-id%", String.valueOf(vault.getVaultId())));
        this.getStorage().updateVault(player.getUniqueId(), vault);
        this.message((CommandSender)player, Message.COMMAND_VAULT_RENAME_RESET, new Object[0]);
        this.openVault(player, vault.getVaultId());
    }

    @Override
    public boolean addItem(UUID uniqueId, ItemStack itemStack) {
        return this.addItem(uniqueId, itemStack, itemStack.getAmount());
    }

    @Override
    public boolean addItem(UUID uniqueId, ItemStack itemStack, long amount) {
        if (itemStack == null || itemStack.getType().isAir()) {
            return false;
        }
        IStorage storage = this.getStorage();
        PlayerVaults playerVaults = this.getPlayerVaults(uniqueId);
        Vault vault = playerVaults.find(itemStack).orElseGet(playerVaults::firstAvailableVault);
        Optional<VaultItem> optional = vault.find(itemStack);
        if (optional.isPresent()) {
            VaultItem vaultItem = optional.get();
            vaultItem.addQuantity(amount);
            storage.updateVaultQuantity(uniqueId, vault.getVaultId(), vaultItem.getSlot(), vaultItem.getQuantity());
        } else {
            int nextSlot = vault.getNextSlot();
            if (nextSlot == -1) {
                return false;
            }
            ZVaultItem newVaultItem = new ZVaultItem(nextSlot, itemStack, amount);
            vault.getVaultItems().put(nextSlot, newVaultItem);
            storage.createVaultItem(uniqueId, vault.getVaultId(), nextSlot, newVaultItem.getQuantity(), ItemStackUtils.serializeItemStack((ItemStack)itemStack));
        }
        return true;
    }

    @Override
    public long getMaterialAmount(Player player, Material material) {
        PlayerVaults playerVaults = this.getPlayerVaults(player.getUniqueId());
        return playerVaults.getVaults().values().stream().mapToLong(vault -> vault.getMaterialAmount(material)).sum();
    }

    @Override
    public void removeMaterial(Player player, Material material, long amountToRemove) {
        PlayerVaults playerVaults = this.getPlayerVaults(player.getUniqueId());
        ItemStack itemStack = new ItemStack(material);
        for (Vault vault : playerVaults.getVaults().values()) {
            Optional<VaultItem> optional = vault.find(itemStack);
            if (!optional.isPresent()) continue;
            VaultItem vaultItem = optional.get();
            vaultItem.removeQuantity(amountToRemove);
            this.getStorage().updateVaultQuantity(player.getUniqueId(), vault.getVaultId(), vaultItem.getSlot(), vaultItem.getQuantity());
            return;
        }
    }

    @Override
    public Collection<Material> getMaterials(Player player) {
        HashSet<Material> materials = new HashSet<Material>();
        PlayerVaults playerVaults = this.getPlayerVaults(player.getUniqueId());
        for (Vault vault : playerVaults.getVaults().values()) {
            materials.addAll(vault.getVaultItems().values().stream().map(vaultItem -> vaultItem.getItemStack().getType()).toList());
        }
        return materials;
    }

    @Override
    public String getDefaultVaultName() {
        return this.defaultVaultName;
    }

    public List<PermissionSlotsVault> getVaultPermissions() {
        return this.vaultPermissions;
    }
}

