/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.module.modules.vault;

import fr.maxlego08.essentials.api.dto.VaultDTO;
import fr.maxlego08.essentials.api.vault.PlayerVaults;
import fr.maxlego08.essentials.api.vault.Vault;
import fr.maxlego08.essentials.api.vault.VaultManager;
import fr.maxlego08.essentials.module.modules.vault.ZVault;
import fr.maxlego08.essentials.zutils.utils.ZUtils;
import fr.maxlego08.menu.zcore.utils.nms.ItemStackUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.inventory.ItemStack;

public class ZPlayerVaults
extends ZUtils
implements PlayerVaults {
    private final VaultManager vaultManager;
    private final UUID uniqueId;
    private final Map<Integer, Vault> vaults = new HashMap<Integer, Vault>();
    private int slots;
    private Vault targetVault;
    private PlayerVaults targetPlayerVaults;

    public ZPlayerVaults(VaultManager vaultManager, UUID uniqueId) {
        this.vaultManager = vaultManager;
        this.uniqueId = uniqueId;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public Map<Integer, Vault> getVaults() {
        return this.vaults;
    }

    @Override
    public void createVault(VaultDTO vaultDTO) {
        this.vaults.put(vaultDTO.vault_id(), new ZVault(vaultDTO.unique_id(), vaultDTO.vault_id(), vaultDTO.name(), ItemStackUtils.deserializeItemStack((String)vaultDTO.icon())));
    }

    @Override
    public int getSlots() {
        return this.slots;
    }

    @Override
    public void setSlots(int slots) {
        this.slots = slots;
    }

    @Override
    public Vault getTargetVault() {
        return this.targetVault;
    }

    @Override
    public void setTargetVault(Vault targetVault) {
        this.targetVault = targetVault;
    }

    @Override
    public PlayerVaults getTargetPlayerVaults() {
        return this.targetPlayerVaults;
    }

    @Override
    public void setTargetPlayerVaults(PlayerVaults targetPlayerVaults) {
        this.targetPlayerVaults = targetPlayerVaults;
    }

    @Override
    public Vault getVault(int vaultId) {
        return this.vaults.computeIfAbsent(vaultId, id -> new ZVault(this.uniqueId, (int)id, this.vaultManager.getDefaultVaultName()));
    }

    @Override
    public Optional<Vault> find(ItemStack currentItem) {
        return this.vaults.values().stream().filter(vault -> vault.contains(currentItem)).findFirst();
    }

    @Override
    public Vault firstAvailableVault() {
        if (this.vaults.isEmpty()) {
            return this.getVault(1);
        }
        Optional<Vault> optional = this.vaults.values().stream().filter(Vault::hasFreeSlot).findFirst();
        if (optional.isEmpty()) {
            int nextId = this.vaults.values().stream().map(Vault::getVaultId).sorted().findFirst().orElse(0) + 1;
            return this.getVault(nextId);
        }
        return optional.get();
    }
}

