/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.module.modules.worldedit.taks;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.api.worldedit.Cuboid;
import fr.maxlego08.essentials.api.worldedit.MaterialPercent;
import fr.maxlego08.essentials.api.worldedit.WorldEditTask;
import fr.maxlego08.essentials.api.worldedit.WorldeditAction;
import fr.maxlego08.essentials.api.worldedit.WorldeditManager;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Block;

public class CylTask
extends WorldEditTask {
    private final int radius;
    private final int height;
    private final boolean filled;

    public CylTask(EssentialsPlugin plugin, WorldeditManager worldeditManager, User user, Cuboid cuboid, List<MaterialPercent> materialPercents, int radius, int height, boolean filled) {
        super(plugin, worldeditManager, user, cuboid, materialPercents);
        this.radius = radius;
        this.height = height;
        this.filled = filled;
    }

    @Override
    public void loadBlocks() {
        Location centerLocation = this.user.getSelection().getFirstLocation();
        Block centerBlock = centerLocation.getBlock();
        int ceilRadius = (int)((double)this.radius);
        for (int y = 0; y < this.height; ++y) {
            for (int x = -ceilRadius; x <= ceilRadius; ++x) {
                for (int z = -ceilRadius; z <= ceilRadius; ++z) {
                    if (x * x + z * z >= this.radius * this.radius || !this.filled && this.lengthSq(x, z) <= (double)(this.radius * this.radius - this.radius * 2)) continue;
                    this.blocks.add(centerBlock.getRelative(x, y, z));
                }
            }
        }
    }

    @Override
    public WorldeditAction getAction() {
        return WorldeditAction.PLACE;
    }
}

