/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.module.modules.worldedit.taks;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.api.worldedit.Cuboid;
import fr.maxlego08.essentials.api.worldedit.MaterialPercent;
import fr.maxlego08.essentials.api.worldedit.WorldEditTask;
import fr.maxlego08.essentials.api.worldedit.WorldeditAction;
import fr.maxlego08.essentials.api.worldedit.WorldeditManager;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Block;

public class SphereTask
extends WorldEditTask {
    private final int radius;
    private final boolean filled;

    public SphereTask(EssentialsPlugin plugin, WorldeditManager worldeditManager, User user, Cuboid cuboid, List<MaterialPercent> materialPercents, int radius, boolean filled) {
        super(plugin, worldeditManager, user, cuboid, materialPercents);
        this.radius = radius;
        this.filled = filled;
    }

    @Override
    public void loadBlocks() {
        Location centerLocation = this.user.getSelection().getFirstLocation();
        Block centerBlock = centerLocation.getBlock();
        int ceilRadius = (int)((double)this.radius);
        for (int y = -ceilRadius; y <= ceilRadius; ++y) {
            for (int x = -ceilRadius; x <= ceilRadius; ++x) {
                for (int z = -ceilRadius; z <= ceilRadius; ++z) {
                    if (x * x + z * z + y * y >= this.radius * this.radius || !this.filled && this.lengthSq(x, y, z) <= (double)(this.radius * this.radius - this.radius * 2)) continue;
                    this.blocks.add(centerBlock.getRelative(x, y, z));
                }
            }
        }
    }

    @Override
    public WorldeditAction getAction() {
        return WorldeditAction.PLACE;
    }
}

