/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.nms.v1_20_4.enderchest;

import com.mojang.logging.LogUtils;
import fr.maxlego08.essentials.nms.v1_20_4.enderchest.CraftPlayerManager;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.level.storage.WorldNBTStorage;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenPlayer
extends CraftPlayer {
    private static final Set<String> RESET_TAGS = Set.of("CustomName", "CustomNameVisible", "Silent", "NoGravity", "Glowing", "TicksFrozen", "HasVisualFire", "Tags", "Passengers", "warden_spawn_tracker", "enteredNetherPosition", "SpawnX", "SpawnY", "SpawnZ", "SpawnForced", "SpawnAngle", "SpawnDimension", "ShoulderEntityLeft", "ShoulderEntityRight", "LastDeathLocation", "ActiveEffects", "active_effects", "SleepingX", "SleepingY", "SleepingZ", "Brain");
    private final CraftPlayerManager manager;

    OpenPlayer(CraftServer server, EntityPlayer entity, CraftPlayerManager manager) {
        super(server, entity);
        this.manager = manager;
    }

    public void loadData() {
        this.manager.loadData(this.getHandle());
    }

    public void saveData() {
        EntityPlayer player = this.getHandle();
        try {
            WorldNBTStorage worldNBTStorage = player.d.ae().t;
            NBTTagCompound oldData = this.isOnline() ? null : worldNBTStorage.getPlayerData(player.cx());
            NBTTagCompound playerData = this.getWritableTag(oldData);
            playerData = player.f(playerData);
            this.setExtraData(playerData);
            if (oldData != null) {
                this.revertSpecialValues(playerData, oldData);
            }
            Path playerDataDir = worldNBTStorage.getPlayerDir().toPath();
            Path file = Files.createTempFile(playerDataDir, player.cx() + "-", ".dat", new FileAttribute[0]);
            NBTCompressedStreamTools.a((NBTTagCompound)playerData, (Path)file);
            Path dataFile = playerDataDir.resolve(player.cx() + ".dat");
            Path backupFile = playerDataDir.resolve(player.cx() + ".dat_old");
            SystemUtils.a((Path)dataFile, (Path)file, (Path)backupFile);
        }
        catch (Exception e) {
            LogUtils.getLogger().warn("Failed to save player data for {}: {}", (Object)player.cy(), (Object)e);
        }
    }

    @Contract(value="null -> new")
    @NotNull
    private NBTTagCompound getWritableTag(@Nullable NBTTagCompound oldData) {
        if (oldData == null) {
            return new NBTTagCompound();
        }
        oldData = oldData.h();
        oldData.e().removeIf(key -> RESET_TAGS.contains(key) || key.startsWith("Bukkit"));
        return oldData;
    }

    private void revertSpecialValues(@NotNull NBTTagCompound newData, @NotNull NBTTagCompound oldData) {
        this.copyValue(oldData, newData, "bukkit", "lastPlayed", NBTNumber.class);
        this.copyValue(oldData, newData, "Paper", "LastSeen", NBTNumber.class);
        this.copyValue(oldData, newData, "Paper", "LastLogin", NBTNumber.class);
    }

    private <T extends NBTBase> void copyValue(@NotNull NBTTagCompound source, @NotNull NBTTagCompound target, @NotNull String container, @NotNull String key, @NotNull Class<T> tagType) {
        NBTTagCompound oldContainer = this.getTag(source, container, NBTTagCompound.class);
        NBTTagCompound newContainer = this.getTag(target, container, NBTTagCompound.class);
        if (newContainer == null) {
            return;
        }
        this.setTag(newContainer, key, this.getTag(oldContainer, key, tagType));
    }

    @Nullable
    private <T extends NBTBase> T getTag(@Nullable NBTTagCompound container, @NotNull String key, @NotNull Class<T> dataType) {
        if (container == null) {
            return null;
        }
        NBTBase value = container.c(key);
        if (value == null || !dataType.isAssignableFrom(value.getClass())) {
            return null;
        }
        return (T)((NBTBase)dataType.cast(value));
    }

    private <T extends NBTBase> void setTag(@NotNull NBTTagCompound container, @NotNull String key, @Nullable T data) {
        if (data == null) {
            container.r(key);
        } else {
            container.a(key, data);
        }
    }
}

