/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.placeholders;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.functionnals.ReturnBiConsumer;
import fr.maxlego08.essentials.api.functionnals.ReturnConsumer;
import fr.maxlego08.essentials.api.placeholders.Placeholder;
import fr.maxlego08.essentials.placeholders.AutoPlaceholder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class LocalPlaceholder
implements Placeholder {
    private final Pattern pattern = Pattern.compile("[%]([^%]+)[%]");
    private final List<AutoPlaceholder> autoPlaceholders = new ArrayList<AutoPlaceholder>();
    private final EssentialsPlugin plugin;
    private final String prefix = "zessentials";

    public LocalPlaceholder(EssentialsPlugin plugin) {
        this.plugin = plugin;
    }

    public String setPlaceholders(Player player, String placeholder) {
        if (placeholder == null || !placeholder.contains("%")) {
            return placeholder;
        }
        String realPrefix = this.prefix + "_";
        Matcher matcher = this.pattern.matcher(placeholder);
        while (matcher.find()) {
            String stringPlaceholder = matcher.group(0);
            String regex = matcher.group(1).replace(realPrefix, "");
            String replace = this.onRequest(player, regex);
            if (replace == null) continue;
            placeholder = placeholder.replace(stringPlaceholder, replace);
        }
        return placeholder;
    }

    public List<String> setPlaceholders(Player player, List<String> lore) {
        return lore == null ? null : lore.stream().map(e -> {
            e = this.setPlaceholders(player, (String)e);
            return e;
        }).collect(Collectors.toList());
    }

    @Override
    public String onRequest(Player player, String string) {
        if (string == null || player == null) {
            return null;
        }
        Optional<AutoPlaceholder> optional = this.autoPlaceholders.stream().filter(autoPlaceholder -> autoPlaceholder.startsWith(string)).findFirst();
        if (optional.isPresent()) {
            AutoPlaceholder autoPlaceholder2 = optional.get();
            String value = string.replace(autoPlaceholder2.getStartWith(), "");
            return autoPlaceholder2.accept(player, value);
        }
        return null;
    }

    @Override
    public void register(String startWith, ReturnBiConsumer<Player, String, String> biConsumer, String description, String ... args) {
        this.autoPlaceholders.add(new AutoPlaceholder(startWith, biConsumer, description, Arrays.asList(args)));
    }

    @Override
    public void register(String startWith, ReturnConsumer<Player, String> biConsumer, String description) {
        this.autoPlaceholders.add(new AutoPlaceholder(startWith, biConsumer, description));
    }

    @Override
    public String getPrefix() {
        return "zessentials";
    }

    public EssentialsPlugin getPlugin() {
        return this.plugin;
    }

    public List<AutoPlaceholder> getAutoPlaceholders() {
        return this.autoPlaceholders;
    }
}

