/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.storage.adapter;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.dto.CooldownDTO;
import fr.maxlego08.essentials.api.dto.HomeDTO;
import fr.maxlego08.essentials.api.dto.OptionDTO;
import fr.maxlego08.essentials.api.home.Home;
import fr.maxlego08.essentials.api.user.Option;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.api.utils.SafeLocation;
import fr.maxlego08.essentials.user.ZUser;
import fr.maxlego08.essentials.zutils.utils.LocationUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Material;

public class UserTypeAdapter
extends TypeAdapter<User> {
    private final EssentialsPlugin plugin;
    private final LocationUtils locationUtils = new LocationUtils(this){};

    public UserTypeAdapter(EssentialsPlugin plugin) {
        this.plugin = plugin;
    }

    public void write(JsonWriter out, User value) throws IOException {
        out.beginObject();
        out.name("uniqueId").value(value.getUniqueId().toString());
        out.name("name").value(value.getName());
        if (value.getLastLocation() != null) {
            out.name("lastLocation").value(this.locationUtils.locationAsString(value.getLastLocation()));
        }
        out.name("options").beginObject();
        for (Map.Entry<Option, Boolean> entry : value.getOptions().entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            out.name(entry.getKey().name()).value(entry.getValue());
        }
        out.endObject();
        out.name("cooldowns").beginObject();
        for (Map.Entry<Object, Comparable<Boolean>> entry : value.getCooldowns().entrySet()) {
            out.name((String)entry.getKey()).value((Number)((Object)entry.getValue()));
        }
        out.endObject();
        out.name("balances").beginObject();
        for (Map.Entry<Object, Comparable<Boolean>> entry : value.getBalances().entrySet()) {
            out.name((String)entry.getKey()).value((Number)((Object)entry.getValue()));
        }
        out.endObject();
        out.name("homes").beginArray();
        for (Home home : value.getHomes()) {
            out.beginObject();
            out.name("name").value(home.getName());
            out.name("location").value(this.locationUtils.locationAsString(home.getLocation()));
            if (home.getMaterial() != null) {
                out.name("material").value(home.getMaterial().name());
            }
            out.endObject();
        }
        out.endArray();
        out.name("power-tools").beginObject();
        for (Map.Entry entry : value.getPowerTools().entrySet()) {
            out.name(((Material)entry.getKey()).name()).value((String)entry.getValue());
        }
        out.endObject();
        out.endObject();
    }

    public User read(JsonReader in) throws IOException {
        String name = null;
        UUID uniqueId = null;
        HashMap<Material, String> powerTools = new HashMap<Material, String>();
        HashMap<Option, Boolean> options = new HashMap<Option, Boolean>();
        HashMap<String, Long> cooldowns = new HashMap<String, Long>();
        HashMap<String, BigDecimal> balances = new HashMap<String, BigDecimal>();
        ArrayList<HomeDTO> homeDTOS = new ArrayList<HomeDTO>();
        SafeLocation lastLocation = null;
        in.beginObject();
        while (in.hasNext()) {
            switch (in.nextName()) {
                case "uniqueId": {
                    uniqueId = UUID.fromString(in.nextString());
                    break;
                }
                case "name": {
                    name = in.nextString();
                    break;
                }
                case "lastLocation": {
                    lastLocation = this.locationUtils.stringAsLocation(in.nextString());
                    break;
                }
                case "options": {
                    in.beginObject();
                    while (in.hasNext()) {
                        options.put(Option.valueOf(in.nextName()), in.nextBoolean());
                    }
                    in.endObject();
                    break;
                }
                case "cooldowns": {
                    in.beginObject();
                    while (in.hasNext()) {
                        cooldowns.put(in.nextName(), in.nextLong());
                    }
                    in.endObject();
                    break;
                }
                case "power-tools": {
                    in.beginObject();
                    while (in.hasNext()) {
                        powerTools.put(Material.valueOf((String)in.nextName()), in.nextString());
                    }
                    in.endObject();
                    break;
                }
                case "balances": {
                    in.beginObject();
                    while (in.hasNext()) {
                        String key = in.nextName();
                        BigDecimal value = new BigDecimal(in.nextString());
                        balances.put(key, value);
                    }
                    in.endObject();
                    break;
                }
                case "homes": {
                    in.beginArray();
                    while (in.hasNext()) {
                        in.beginObject();
                        String homeName = null;
                        String location = null;
                        String material = null;
                        while (in.hasNext()) {
                            switch (in.nextName()) {
                                case "name": {
                                    homeName = in.nextString();
                                    break;
                                }
                                case "location": {
                                    location = in.nextString();
                                    break;
                                }
                                case "material": {
                                    material = in.nextString();
                                }
                            }
                        }
                        in.endObject();
                        homeDTOS.add(new HomeDTO(location, homeName, material));
                    }
                    in.endArray();
                }
            }
        }
        in.endObject();
        if (uniqueId == null) {
            throw new IOException("UniqueId is missing from the JSON input.");
        }
        ZUser user = new ZUser(this.plugin, uniqueId);
        user.setName(name);
        user.setOptions(options.entrySet().stream().map(entry -> new OptionDTO((Option)((Object)((Object)entry.getKey())), (Boolean)entry.getValue())).collect(Collectors.toList()));
        user.setCooldowns(cooldowns.entrySet().stream().map(entry -> new CooldownDTO((String)entry.getKey(), (Long)entry.getValue(), new Date())).collect(Collectors.toList()));
        user.setLastLocation(lastLocation);
        user.setHomes(homeDTOS);
        user.setPowerTools(powerTools);
        balances.forEach(user::setBalance);
        return user;
    }
}

