/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.storage.database;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.libs.sarah.DatabaseConnection;
import fr.maxlego08.essentials.libs.sarah.SchemaBuilder;
import fr.maxlego08.essentials.libs.sarah.database.Schema;
import fr.maxlego08.essentials.libs.sarah.logger.JULogger;
import fr.maxlego08.essentials.libs.sarah.requests.InsertBatchRequest;
import fr.maxlego08.essentials.libs.sarah.requests.UpsertBatchRequest;
import fr.maxlego08.essentials.zutils.utils.ZUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public abstract class Repository
extends ZUtils {
    protected final EssentialsPlugin plugin;
    protected final DatabaseConnection connection;
    private final String tableName;

    public Repository(EssentialsPlugin plugin, DatabaseConnection connection, String tableName) {
        this.plugin = plugin;
        this.connection = connection;
        this.tableName = tableName;
    }

    protected Connection getConnection() {
        return this.connection.getConnection();
    }

    public String getTableName() {
        return this.connection.getDatabaseConfiguration().getTablePrefix() + this.tableName;
    }

    protected void upsert(Consumer<Schema> consumer) {
        try {
            SchemaBuilder.upsert(this.getTableName(), consumer).execute(this.connection, JULogger.from(this.plugin.getLogger()));
        }
        catch (SQLException exception) {
            exception.printStackTrace();
        }
    }

    protected void update(Consumer<Schema> consumer) {
        try {
            SchemaBuilder.update(this.getTableName(), consumer).execute(this.connection, JULogger.from(this.plugin.getLogger()));
        }
        catch (SQLException exception) {
            exception.printStackTrace();
        }
    }

    protected void insert(Consumer<Schema> consumer) {
        this.insert(consumer, id -> {});
    }

    protected void insert(Consumer<Schema> consumer, Consumer<Integer> consumerResult) {
        try {
            consumerResult.accept(SchemaBuilder.insert(this.getTableName(), consumer).execute(this.connection, JULogger.from(this.plugin.getLogger())));
        }
        catch (SQLException exception) {
            exception.printStackTrace();
        }
    }

    protected long select(Consumer<Schema> consumer) {
        Schema schema = SchemaBuilder.selectCount(this.getTableName());
        consumer.accept(schema);
        try {
            return schema.executeSelectCount(this.connection, JULogger.from(this.plugin.getLogger()));
        }
        catch (SQLException exception) {
            exception.printStackTrace();
            return 0L;
        }
    }

    protected <T> List<T> select(Class<T> clazz, Consumer<Schema> consumer) {
        Schema schema = SchemaBuilder.select(this.getTableName());
        consumer.accept(schema);
        try {
            return schema.executeSelect(clazz, this.connection, JULogger.from(this.plugin.getLogger()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new ArrayList();
        }
    }

    protected int delete(Consumer<Schema> consumer) {
        Schema schema = SchemaBuilder.delete(this.getTableName());
        consumer.accept(schema);
        try {
            return schema.execute(this.connection, JULogger.from(this.plugin.getLogger()));
        }
        catch (SQLException exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    protected void insert(List<Schema> schemas) {
        InsertBatchRequest insertBatchRequest = new InsertBatchRequest(schemas);
        insertBatchRequest.execute(this.connection, this.connection.getDatabaseConfiguration(), JULogger.from(this.plugin.getLogger()));
    }

    protected void upsert(List<Schema> schemas) {
        UpsertBatchRequest upsertBatchRequest = new UpsertBatchRequest(schemas);
        upsertBatchRequest.execute(this.connection, this.connection.getDatabaseConfiguration(), JULogger.from(this.plugin.getLogger()));
    }

    protected Schema schema(Consumer<Schema> consumer) {
        return SchemaBuilder.insert(this.getTableName(), consumer);
    }
}

