/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.storage.database.repositeries;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.dto.ChatMessageDTO;
import fr.maxlego08.essentials.libs.sarah.DatabaseConnection;
import fr.maxlego08.essentials.storage.database.Repository;
import java.util.List;
import java.util.UUID;

public class ChatMessagesRepository
extends Repository {
    public ChatMessagesRepository(EssentialsPlugin plugin, DatabaseConnection connection) {
        super(plugin, connection, "chat_message");
    }

    public List<ChatMessageDTO> getMessages(UUID uuid) {
        return this.select(ChatMessageDTO.class, table -> {
            table.uuid("unique_id", uuid);
            table.orderByDesc("created_at");
        });
    }

    public void insertMessages(List<ChatMessageDTO> messages) {
        this.insert(messages.stream().map(dto -> this.schema(table -> {
            table.uuid("unique_id", dto.unique_id());
            table.string("content", dto.content());
        })).toList());
    }
}

