/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.storage.database.repositeries;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.dto.EconomyTransactionDTO;
import fr.maxlego08.essentials.api.economy.Economy;
import fr.maxlego08.essentials.libs.sarah.DatabaseConnection;
import fr.maxlego08.essentials.storage.database.Repository;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public class EconomyTransactionsRepository
extends Repository {
    public EconomyTransactionsRepository(EssentialsPlugin plugin, DatabaseConnection connection) {
        super(plugin, connection, "economy_transactions");
    }

    public List<EconomyTransactionDTO> selectTransactions(UUID toUuid, Economy economy) {
        return this.select(EconomyTransactionDTO.class, table -> table.where("to_unique_id", toUuid).where("economy_name", economy.getName())).stream().map(transactionDTO -> new EconomyTransactionDTO(transactionDTO.from_unique_id(), transactionDTO.to_unique_id(), transactionDTO.economy_name(), transactionDTO.reason() == null ? "No reason" : transactionDTO.reason(), transactionDTO.amount(), transactionDTO.from_amount(), transactionDTO.to_amount(), transactionDTO.created_at(), transactionDTO.updated_at())).collect(Collectors.toList());
    }

    public void insertTransactions(List<EconomyTransactionDTO> transactions) {
        this.insert(transactions.stream().map(transaction -> this.schema(table -> {
            table.uuid("from_unique_id", transaction.from_unique_id());
            table.uuid("to_unique_id", transaction.to_unique_id());
            table.string("economy_name", transaction.economy_name());
            table.string("reason", transaction.reason() == null ? "No reason" : transaction.reason());
            table.decimal("amount", transaction.amount());
            table.decimal("from_amount", transaction.from_amount());
            table.decimal("to_amount", transaction.to_amount());
        })).toList());
    }
}

