/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.storage.database.repositeries;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.dto.PowerToolsDTO;
import fr.maxlego08.essentials.libs.sarah.DatabaseConnection;
import fr.maxlego08.essentials.libs.sarah.database.Schema;
import fr.maxlego08.essentials.storage.database.Repository;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;

public class UserPowerToolsRepository
extends Repository {
    public UserPowerToolsRepository(EssentialsPlugin plugin, DatabaseConnection connection) {
        super(plugin, connection, "user_power_tools");
    }

    public void upsert(UUID uuid, Material material, String command) {
        this.upsert((Schema table) -> {
            table.uuid("unique_id", uuid).primary();
            table.string("material", material.name()).primary();
            table.string("command", command);
        });
    }

    public List<PowerToolsDTO> select(UUID uuid) {
        return this.select(PowerToolsDTO.class, table -> table.where("unique_id", uuid));
    }

    public void delete(UUID uuid, Material material) {
        this.delete(table -> table.where("unique_id", uuid).where("material", material.name()));
    }
}

