/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.storage.database.repositeries;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.dto.VoteSiteDTO;
import fr.maxlego08.essentials.libs.sarah.DatabaseConnection;
import fr.maxlego08.essentials.libs.sarah.database.Schema;
import fr.maxlego08.essentials.storage.database.Repository;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class VoteSiteRepository
extends Repository {
    public VoteSiteRepository(EssentialsPlugin plugin, DatabaseConnection connection) {
        super(plugin, connection, "vote_sites");
    }

    public List<VoteSiteDTO> select(UUID uniqueId) {
        return this.select(VoteSiteDTO.class, table -> table.where("player_id", uniqueId));
    }

    public void setLastVote(UUID uniqueId, String site) {
        this.upsert((Schema table) -> {
            table.uuid("player_id", uniqueId).primary();
            table.string("site", site).primary();
            table.object("last_vote_at", new Date());
        });
    }
}

