/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.task;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.zutils.utils.TimerBuilder;
import fr.maxlego08.essentials.zutils.utils.ZUtils;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FlyTask
extends ZUtils {
    public FlyTask(EssentialsPlugin plugin) {
        plugin.getScheduler().runTimer(task -> {
            if (!plugin.isEnabled()) {
                task.cancel();
                return;
            }
            List<Long> announces = plugin.getConfiguration().getFlyTaskAnnounce();
            for (Player player : plugin.getServer().getOnlinePlayers()) {
                User user;
                if (!player.isFlying() || player.hasPermission(Permission.ESSENTIALS_FLY_UNLIMITED.asPermission()) || player.getGameMode() != GameMode.ADVENTURE && player.getGameMode() != GameMode.SURVIVAL || (user = plugin.getUser(player.getUniqueId())) == null) continue;
                long seconds = user.getFlySeconds() - 1L;
                if (announces.contains(seconds)) {
                    this.message((CommandSender)player, Message.COMMAND_FLY_REMAINING, "%time%", TimerBuilder.getStringTime(seconds * 1000L));
                }
                if (seconds <= 0L) {
                    player.setAllowFlight(false);
                    player.setFlying(false);
                    this.message((CommandSender)player, Message.COMMAND_FLY_END, new Object[0]);
                }
                user.setFlySeconds(seconds);
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }
}

