/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.zutils.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class TypeSafeCache {
    private final Map<Class<?>, List<Object>> cache = new ConcurrentHashMap();

    public void add(Object object) {
        Class<?> type = object.getClass();
        this.cache.computeIfAbsent(type, k -> new ArrayList()).add(object);
    }

    @NotNull
    public <T> List<T> get(Class<T> type) {
        return this.cache.getOrDefault(type, new ArrayList());
    }

    public void clear(Class<?> type) {
        this.cache.put(type, new ArrayList());
    }

    public void clearAll() {
        this.cache.clear();
    }

    public boolean remove(Object object) {
        Class<?> type = object.getClass();
        List<Object> list = this.cache.get(type);
        if (list != null) {
            return list.remove(object);
        }
        return false;
    }
}

