/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.zutils.utils.component;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fr.maxlego08.essentials.zutils.utils.component.adapters.ClickAdapter;
import fr.maxlego08.essentials.zutils.utils.component.adapters.HoverAdapter;
import fr.maxlego08.essentials.zutils.utils.component.adapters.KeyBindAdapter;
import fr.maxlego08.essentials.zutils.utils.component.adapters.TextAdapter;
import fr.maxlego08.essentials.zutils.utils.component.adapters.TranslatingAdapter;
import fr.maxlego08.essentials.zutils.utils.component.components.ClickEvent;
import fr.maxlego08.essentials.zutils.utils.component.components.DefaultComponent;
import fr.maxlego08.essentials.zutils.utils.component.components.HoverEvent;
import fr.maxlego08.essentials.zutils.utils.component.components.KeyBindComponent;
import fr.maxlego08.essentials.zutils.utils.component.components.TextComponent;
import fr.maxlego08.essentials.zutils.utils.component.components.TranslatingComponent;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.TranslatableComponent;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractComponent {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ClickEvent.class, (Object)new ClickAdapter()).registerTypeAdapter(HoverEvent.class, (Object)new HoverAdapter()).registerTypeAdapter(TextComponent.class, (Object)new TextAdapter()).registerTypeAdapter(KeyBindComponent.class, (Object)new KeyBindAdapter()).registerTypeAdapter(TranslatingComponent.class, (Object)new TranslatingAdapter()).create();
    protected final List<AbstractComponent> extra = new LinkedList<AbstractComponent>();

    public static AbstractComponent parse(@NotNull String json) {
        try {
            return AbstractComponent.parse(JsonParser.parseString((String)json));
        }
        catch (Throwable ignored) {
            return new DefaultComponent(json);
        }
    }

    public static AbstractComponent parse(@NotNull Component component) {
        if (component instanceof net.kyori.adventure.text.TextComponent) {
            return new TextComponent((net.kyori.adventure.text.TextComponent)component);
        }
        if (component instanceof KeybindComponent) {
            return new KeyBindComponent((KeybindComponent)component);
        }
        if (component instanceof TranslatableComponent) {
            return new TranslatingComponent((TranslatableComponent)component);
        }
        return new DefaultComponent(component);
    }

    public static AbstractComponent parse(@NotNull JsonElement element) {
        if (element.isJsonObject()) {
            JsonObject jsonObject = element.getAsJsonObject();
            if (jsonObject.has("keybind")) {
                return (AbstractComponent)GSON.fromJson(element, KeyBindComponent.class);
            }
            if (jsonObject.has("translate")) {
                return (AbstractComponent)GSON.fromJson(element, TranslatingComponent.class);
            }
            return (AbstractComponent)GSON.fromJson(element, TextComponent.class);
        }
        if (element.isJsonArray()) {
            TextComponent component = new TextComponent();
            for (JsonElement found : element.getAsJsonArray()) {
                component.extra.add(AbstractComponent.parse(found));
            }
            return component;
        }
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
            return new TextComponent(element.getAsString());
        }
        return new DefaultComponent(element.getAsString());
    }

    public abstract String toMiniMessage();

    public JsonElement toJsonElement() {
        return GSON.toJsonTree((Object)this);
    }

    public List<AbstractComponent> getExtra() {
        return this.extra;
    }

    protected String getExtraAsMiniMessage() {
        return this.extra.stream().map(AbstractComponent::toMiniMessage).collect(Collectors.joining());
    }
}

