/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.zutils.utils.component.components;

import fr.maxlego08.essentials.zutils.utils.component.AbstractComponent;
import fr.maxlego08.essentials.zutils.utils.component.adapters.HoverAdapter;
import fr.maxlego08.essentials.zutils.utils.component.components.TextComponent;
import net.kyori.adventure.text.event.HoverEvent;

public class HoverEvent {
    private final String action;
    private final Object value;

    public HoverEvent(String action, Object value) {
        this.action = action;
        this.value = value;
    }

    public HoverEvent(net.kyori.adventure.text.event.HoverEvent event) {
        this(event.action().toString(), HoverEvent.getValueFromEvent(event));
    }

    private static Object getValueFromEvent(net.kyori.adventure.text.event.HoverEvent event) {
        return switch (event.action().toString()) {
            case "show_achievement" -> new TextComponent(event.value().toString());
            case "show_item" -> new HoverAdapter.ShowItem((HoverEvent.ShowItem)event.value());
            case "show_entity" -> new HoverAdapter.ShowEntity((HoverEvent.ShowEntity)event.value());
            default -> new TextComponent((net.kyori.adventure.text.TextComponent)event.value());
        };
    }

    public String getAction() {
        return this.action;
    }

    public Object getValue() {
        return this.value;
    }

    private String getValueAsString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof AbstractComponent) {
            AbstractComponent component = (AbstractComponent)value;
            return component.toMiniMessage();
        }
        if (value instanceof HoverAdapter.ShowItem) {
            HoverAdapter.ShowItem showItem = (HoverAdapter.ShowItem)value;
            return showItem.toMiniMessage();
        }
        if (value instanceof HoverAdapter.ShowEntity) {
            HoverAdapter.ShowEntity showEntity = (HoverAdapter.ShowEntity)value;
            return showEntity.toMiniMessage();
        }
        throw new IllegalArgumentException("Unsupported value type: " + value.getClass().getName());
    }

    public String toMiniMessage() {
        return String.format("<hover:%s:\"%s\">", this.action, this.getValueAsString(this.value));
    }
}

