/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.zutils.utils.component.components;

import fr.maxlego08.essentials.zutils.utils.component.AbstractComponent;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.TextColor;

public class TranslatingComponent
extends AbstractComponent {
    private final List<AbstractComponent> with = new LinkedList<AbstractComponent>();
    private final String key;
    private String color;

    public TranslatingComponent(String key, String color) {
        this.key = key;
        this.color = color;
    }

    public TranslatingComponent(TranslatableComponent component) {
        List args;
        this.key = component.key();
        TextColor color = component.color();
        if (color != null) {
            this.color = color.asHexString();
        }
        if (!(args = ComponentLike.asComponents((List)component.arguments())).isEmpty()) {
            for (Component arg : args) {
                this.with.add(AbstractComponent.parse(arg));
            }
        }
        if (!component.children().isEmpty()) {
            for (Component child : component.children()) {
                this.extra.add(AbstractComponent.parse(child));
            }
        }
    }

    @Override
    public String toMiniMessage() {
        StringBuilder builder = new StringBuilder();
        if (this.color != null) {
            builder.append("<color:").append(this.color).append(">");
        }
        builder.append("<lang:").append(this.key);
        String withComponents = this.with.stream().map(component -> ":\"" + component.toMiniMessage() + "\"").collect(Collectors.joining());
        builder.append(withComponents).append(">");
        builder.append(this.getExtraAsMiniMessage());
        if (this.color != null) {
            builder.append("</color>");
        }
        return builder.toString();
    }

    public String getKey() {
        return this.key;
    }

    public String getColor() {
        return this.color;
    }

    public List<AbstractComponent> getWith() {
        return this.with;
    }
}

