/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.zutils.utils.cube;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Display;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TextDisplay;
import org.bukkit.util.Transformation;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CubeDisplay {
    private final List<TextDisplay> faces = new ArrayList<TextDisplay>();
    private final Location center;
    private double width;
    private double height;
    private double depth;
    private Color backgroundColor;

    public CubeDisplay(Location center, double width, double height, double depth, Color backgroundColor) {
        this.center = center;
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.backgroundColor = backgroundColor;
    }

    public void update(double width, double height, double depth, Color backgroundColor) {
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.backgroundColor = backgroundColor;
        this.remove();
        this.spawn();
    }

    public void spawn() {
        World world = this.center.getWorld();
        if (world == null) {
            return;
        }
        int div = 8;
        this.faces.add(this.createFace(world, this.center.clone().add(0.0, 0.0, -(this.depth / (double)div)), this.width, this.height, 180.0f, 0.0f));
        this.faces.add(this.createFace(world, this.center.clone().add(0.0, 0.0, this.depth / (double)div), this.width, this.height, 0.0f, 0.0f));
        this.faces.add(this.createFace(world, this.center.clone().add(-(this.width / (double)div), 0.0, 0.0), this.depth, this.height, 90.0f, 0.0f));
        this.faces.add(this.createFace(world, this.center.clone().add(this.width / (double)div, 0.0, 0.0), this.depth, this.height, -90.0f, 0.0f));
        this.faces.add(this.createFace(world, this.center.clone().add(0.0, this.height / (double)div, 0.0), this.width, this.depth, 0.0f, -90.0f));
        this.faces.add(this.createFace(world, this.center.clone().add(0.0, -this.height / (double)div, 0.0), this.width, this.depth, 0.0f, 90.0f));
    }

    private TextDisplay createFace(World world, Location location, double faceWidth, double faceHeight, float yaw, float pitch) {
        location.setYaw(yaw);
        location.setPitch(pitch);
        TextDisplay display = (TextDisplay)world.spawnEntity(location, EntityType.TEXT_DISPLAY);
        display.text((Component)Component.text((String)" "));
        display.setPersistent(false);
        display.setBackgroundColor(this.backgroundColor);
        display.setBillboard(Display.Billboard.FIXED);
        Transformation transformation = display.getTransformation();
        transformation.getScale().set((float)faceWidth * 2.0f, (float)faceHeight, 1.0f);
        transformation.getTranslation().set((Vector3fc)new Vector3f((float)(faceHeight * -0.025), (float)(faceHeight * -0.125), 0.0f));
        display.setTransformation(transformation);
        return display;
    }

    public void remove() {
        for (TextDisplay face : this.faces) {
            if (face == null) continue;
            face.remove();
        }
        this.faces.clear();
    }

    @Nullable
    public List<TextDisplay> getFaces() {
        return this.faces.isEmpty() ? null : this.faces;
    }

    public Location getCenter() {
        return this.center;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getDepth() {
        return this.depth;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }
}

