/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.zutils.utils.documentation;

import fr.maxlego08.essentials.api.commands.EssentialsCommand;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class CommandMarkdownGenerator {
    public void generateMarkdownFile(List<EssentialsCommand> essentialsCommands, Path filePath) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("| Command | Aliases | Permission | Description |\n");
        sb.append("|---------|---------|------------|-------------|\n");
        for (EssentialsCommand command : essentialsCommands) {
            String cmd = command.getSyntax();
            ArrayList<String> aliasesList = new ArrayList<String>(command.getSubCommands());
            if (!aliasesList.isEmpty()) {
                aliasesList.remove(0);
            }
            String aliases = aliasesList.stream().map(alias -> "/" + alias).collect(Collectors.joining(", "));
            String perm = command.getPermission();
            String desc = command.getDescription();
            desc = desc == null ? "" : desc.replace("|", "\\|");
            perm = perm == null ? "" : perm;
            sb.append(String.format("| `%s` | %s | %s | %s |\n", cmd, aliases, perm, desc));
        }
        Files.writeString(filePath, (CharSequence)sb.toString(), new OpenOption[0]);
    }
}

