/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.maxlego08.essentials.MainConfiguration;
import fr.maxlego08.essentials.api.Configuration;
import fr.maxlego08.essentials.api.ConfigurationFile;
import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.afk.AfkManager;
import fr.maxlego08.essentials.api.block.BlockTracker;
import fr.maxlego08.essentials.api.chat.InteractiveChat;
import fr.maxlego08.essentials.api.commands.CommandManager;
import fr.maxlego08.essentials.api.commands.EssentialsCommand;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.discord.DiscordManager;
import fr.maxlego08.essentials.api.economy.EconomyManager;
import fr.maxlego08.essentials.api.enchantment.Enchantments;
import fr.maxlego08.essentials.api.hologram.HologramManager;
import fr.maxlego08.essentials.api.home.HomeManager;
import fr.maxlego08.essentials.api.kit.Kit;
import fr.maxlego08.essentials.api.modules.ModuleManager;
import fr.maxlego08.essentials.api.permission.PermissionChecker;
import fr.maxlego08.essentials.api.placeholders.Placeholder;
import fr.maxlego08.essentials.api.placeholders.PlaceholderRegister;
import fr.maxlego08.essentials.api.sanction.SanctionManager;
import fr.maxlego08.essentials.api.scoreboard.ScoreboardManager;
import fr.maxlego08.essentials.api.server.EssentialsServer;
import fr.maxlego08.essentials.api.steps.StepManager;
import fr.maxlego08.essentials.api.storage.Persist;
import fr.maxlego08.essentials.api.storage.ServerStorage;
import fr.maxlego08.essentials.api.storage.StorageManager;
import fr.maxlego08.essentials.api.storage.adapter.LocationAdapter;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.api.utils.EssentialsUtils;
import fr.maxlego08.essentials.api.utils.RandomWord;
import fr.maxlego08.essentials.api.utils.SafeLocation;
import fr.maxlego08.essentials.api.utils.Warp;
import fr.maxlego08.essentials.api.utils.component.ComponentMessage;
import fr.maxlego08.essentials.api.vault.VaultManager;
import fr.maxlego08.essentials.api.vote.VoteManager;
import fr.maxlego08.essentials.api.waypoint.WayPointHelper;
import fr.maxlego08.essentials.api.worldedit.WorldeditManager;
import fr.maxlego08.essentials.buttons.ButtonHomes;
import fr.maxlego08.essentials.buttons.ButtonPayConfirm;
import fr.maxlego08.essentials.buttons.ButtonTeleportationConfirm;
import fr.maxlego08.essentials.buttons.ButtonTeleportationConfirmHere;
import fr.maxlego08.essentials.buttons.kit.ButtonKitPreview;
import fr.maxlego08.essentials.buttons.mail.ButtonMailBox;
import fr.maxlego08.essentials.buttons.mail.ButtonMailBoxAdmin;
import fr.maxlego08.essentials.buttons.sanction.ButtonSanctionInformation;
import fr.maxlego08.essentials.buttons.sanction.ButtonSanctions;
import fr.maxlego08.essentials.buttons.vault.ButtonVaultIcon;
import fr.maxlego08.essentials.buttons.vault.ButtonVaultRename;
import fr.maxlego08.essentials.buttons.vault.ButtonVaultSlotDisable;
import fr.maxlego08.essentials.buttons.vault.ButtonVaultSlotItems;
import fr.maxlego08.essentials.commands.CommandLoader;
import fr.maxlego08.essentials.commands.ZCommandManager;
import fr.maxlego08.essentials.commands.commands.essentials.CommandEssentials;
import fr.maxlego08.essentials.enchantments.ZEnchantments;
import fr.maxlego08.essentials.libs.folialib.FoliaLib;
import fr.maxlego08.essentials.libs.folialib.impl.FoliaImplementation;
import fr.maxlego08.essentials.libs.folialib.impl.PlatformScheduler;
import fr.maxlego08.essentials.listener.InvseeListener;
import fr.maxlego08.essentials.listener.PlayerListener;
import fr.maxlego08.essentials.loader.ButtonKitCooldownLoader;
import fr.maxlego08.essentials.loader.ButtonKitGetLoader;
import fr.maxlego08.essentials.loader.ButtonOptionLoader;
import fr.maxlego08.essentials.loader.ButtonSanctionLoader;
import fr.maxlego08.essentials.loader.ButtonVaultNoPermissionLoader;
import fr.maxlego08.essentials.loader.ButtonVaultOpenLoader;
import fr.maxlego08.essentials.loader.ButtonWarpLoader;
import fr.maxlego08.essentials.messages.MessageLoader;
import fr.maxlego08.essentials.module.ZModuleManager;
import fr.maxlego08.essentials.module.modules.HomeModule;
import fr.maxlego08.essentials.module.modules.MailBoxModule;
import fr.maxlego08.essentials.module.modules.SanctionModule;
import fr.maxlego08.essentials.module.modules.StepModule;
import fr.maxlego08.essentials.module.modules.VoteModule;
import fr.maxlego08.essentials.module.modules.afk.AFKModule;
import fr.maxlego08.essentials.module.modules.chat.interactive.InteractiveChatHelper;
import fr.maxlego08.essentials.module.modules.chat.interactive.InteractiveChatPaperListener;
import fr.maxlego08.essentials.module.modules.chat.interactive.InteractiveChatSpigotListener;
import fr.maxlego08.essentials.module.modules.discord.DiscordModule;
import fr.maxlego08.essentials.module.modules.economy.EconomyModule;
import fr.maxlego08.essentials.module.modules.hologram.HologramModule;
import fr.maxlego08.essentials.module.modules.kit.KitModule;
import fr.maxlego08.essentials.module.modules.scoreboard.ScoreboardModule;
import fr.maxlego08.essentials.module.modules.vault.VaultModule;
import fr.maxlego08.essentials.module.modules.worldedit.WorldeditModule;
import fr.maxlego08.essentials.placeholders.DistantPlaceholder;
import fr.maxlego08.essentials.placeholders.LocalPlaceholder;
import fr.maxlego08.essentials.server.PaperServer;
import fr.maxlego08.essentials.server.SpigotServer;
import fr.maxlego08.essentials.storage.ConfigStorage;
import fr.maxlego08.essentials.storage.ZStorageManager;
import fr.maxlego08.essentials.storage.adapter.UserTypeAdapter;
import fr.maxlego08.essentials.task.FlyTask;
import fr.maxlego08.essentials.user.ZUser;
import fr.maxlego08.essentials.user.placeholders.ArmorPlaceholders;
import fr.maxlego08.essentials.user.placeholders.EconomyBaltopPlaceholders;
import fr.maxlego08.essentials.user.placeholders.RandomWordPlaceholders;
import fr.maxlego08.essentials.user.placeholders.ReplacePlaceholders;
import fr.maxlego08.essentials.user.placeholders.ServerPlaceholders;
import fr.maxlego08.essentials.user.placeholders.UserHomePlaceholders;
import fr.maxlego08.essentials.user.placeholders.UserItems1_21Placeholders;
import fr.maxlego08.essentials.user.placeholders.UserItemsPlaceholders;
import fr.maxlego08.essentials.user.placeholders.UserKitPlaceholders;
import fr.maxlego08.essentials.user.placeholders.UserPlaceholders;
import fr.maxlego08.essentials.user.placeholders.UserPlayTimePlaceholders;
import fr.maxlego08.essentials.user.placeholders.VotePlaceholders;
import fr.maxlego08.essentials.user.placeholders.WorldEditPlaceholders;
import fr.maxlego08.essentials.zutils.Metrics;
import fr.maxlego08.essentials.zutils.ZPlugin;
import fr.maxlego08.essentials.zutils.utils.ComponentMessageHelper;
import fr.maxlego08.essentials.zutils.utils.DefaultBlockTracker;
import fr.maxlego08.essentials.zutils.utils.PlaceholderUtils;
import fr.maxlego08.essentials.zutils.utils.VersionChecker;
import fr.maxlego08.essentials.zutils.utils.ZServerStorage;
import fr.maxlego08.essentials.zutils.utils.documentation.CommandMarkdownGenerator;
import fr.maxlego08.essentials.zutils.utils.documentation.PermissionInfo;
import fr.maxlego08.essentials.zutils.utils.documentation.PermissionMarkdownGenerator;
import fr.maxlego08.essentials.zutils.utils.documentation.PlaceholderMarkdownGenerator;
import fr.maxlego08.essentials.zutils.utils.paper.PaperUtils;
import fr.maxlego08.essentials.zutils.utils.spigot.SpigotUtils;
import fr.maxlego08.menu.api.ButtonManager;
import fr.maxlego08.menu.api.Inventory;
import fr.maxlego08.menu.api.InventoryManager;
import fr.maxlego08.menu.api.loader.ButtonLoader;
import fr.maxlego08.menu.api.loader.NoneLoader;
import fr.maxlego08.menu.api.pattern.PatternManager;
import fr.maxlego08.menu.zcore.utils.nms.NmsVersion;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;

public final class ZEssentialsPlugin
extends ZPlugin
implements EssentialsPlugin {
    private final UUID consoleUniqueId = UUID.fromString("00000000-0000-0000-0000-000000000000");
    private final List<Material> materials = Arrays.stream(Material.values()).filter(e -> !e.name().startsWith("LEGACY_")).toList();
    private final Enchantments enchantments = new ZEnchantments();
    private final List<PermissionChecker> permissionCheckers = new ArrayList<PermissionChecker>();
    private EssentialsUtils essentialsUtils;
    private ServerStorage serverStorage = new ZServerStorage(this);
    private InventoryManager inventoryManager;
    private ButtonManager buttonManager;
    private PatternManager patternManager;
    private EssentialsServer essentialsServer;
    private ScoreboardManager scoreboardManager;
    private HologramManager hologramManager;
    private InteractiveChatHelper interactiveChatHelper;
    private RandomWord randomWord;
    private long serverStartUptime;
    private BlockTracker blockTracker = new DefaultBlockTracker();
    private WayPointHelper wayPointHelper;

    public void onEnable() {
        this.serverStartUptime = System.currentTimeMillis();
        this.saveDefaultConfig();
        this.saveOrUpdateConfiguration("config.yml", true);
        this.enchantments.register();
        FoliaLib foliaLib = new FoliaLib(this);
        this.platformScheduler = foliaLib.getScheduler();
        boolean isPaper = this.isPaperVersion();
        this.essentialsUtils = isPaper ? new PaperUtils(this) : new SpigotUtils(this);
        this.essentialsServer = isPaper ? new PaperServer(this) : new SpigotServer(this);
        this.interactiveChatHelper = isPaper ? new InteractiveChatPaperListener() : new InteractiveChatSpigotListener();
        this.registerListener(this.interactiveChatHelper);
        this.placeholder = new LocalPlaceholder(this);
        DistantPlaceholder distantPlaceholder = new DistantPlaceholder(this, this.placeholder);
        distantPlaceholder.register();
        this.economyManager = new EconomyModule(this);
        this.scoreboardManager = new ScoreboardModule(this);
        this.hologramManager = new HologramModule(this);
        this.inventoryManager = this.getProvider(InventoryManager.class);
        this.buttonManager = this.getProvider(ButtonManager.class);
        this.patternManager = this.getProvider(PatternManager.class);
        this.registerButtons();
        this.moduleManager = new ZModuleManager(this);
        this.gson = this.getGsonBuilder().create();
        this.persist = new Persist(this);
        this.configuration = new MainConfiguration(this);
        this.registerConfiguration(this.configuration);
        this.registerConfiguration(new MessageLoader(this));
        this.configurationFiles.forEach(ConfigurationFile::load);
        ConfigStorage.getInstance().load(this.getPersist());
        this.commandManager = new ZCommandManager(this);
        this.registerListener(this.commandManager);
        this.registerCommand("zessentials", new CommandEssentials(this), "ess");
        CommandLoader commandLoader = new CommandLoader(this);
        commandLoader.loadCommands(this.commandManager);
        this.getLogger().info("Create " + this.commandManager.countCommands() + " commands.");
        this.essentialsServer.onEnable();
        this.storageManager = new ZStorageManager(this);
        this.registerListener(this.storageManager);
        this.storageManager.onEnable();
        this.moduleManager.loadModules();
        this.getVoteManager().startResetTask();
        this.getVaultManager().loadVaults();
        this.registerListener(new PlayerListener(this));
        this.registerPlaceholder(UserPlaceholders.class);
        this.registerPlaceholder(UserItemsPlaceholders.class);
        if (NmsVersion.getCurrentVersion().getVersion() >= NmsVersion.V_1_21.getVersion()) {
            this.registerPlaceholder(UserItems1_21Placeholders.class);
        }
        this.registerPlaceholder(UserHomePlaceholders.class);
        this.registerPlaceholder(UserPlayTimePlaceholders.class);
        this.registerPlaceholder(UserKitPlaceholders.class);
        this.registerPlaceholder(ReplacePlaceholders.class);
        this.registerPlaceholder(EconomyBaltopPlaceholders.class);
        this.registerPlaceholder(VotePlaceholders.class);
        this.registerPlaceholder(WorldEditPlaceholders.class);
        this.registerPlaceholder(ServerPlaceholders.class);
        this.registerPlaceholder(ArmorPlaceholders.class);
        this.randomWord = this.registerPlaceholder(RandomWordPlaceholders.class);
        new Metrics(this, 21703);
        new VersionChecker(this, 325);
        this.loadHooks();
        this.getServer().getServicesManager().register(EssentialsPlugin.class, (Object)this, (Plugin)this, ServicePriority.Normal);
        this.registerListener(new InvseeListener());
        this.generateDocs();
        if (this.configuration.isTempFlyTask()) {
            new FlyTask(this);
        }
    }

    public void onLoad() {
        try {
            YamlConfiguration configuration;
            File file = new File(this.getDataFolder(), "modules/economy/config.yml");
            if (!file.exists()) {
                this.saveResource("modules/economy/config.yml", false);
            }
            if (!(configuration = YamlConfiguration.loadConfiguration((File)file)).getBoolean("enable", false)) {
                return;
            }
            Class.forName("net.milkbowl.vault.economy.Economy");
            Optional optional = this.createInstance("VaultEconomy");
            if (optional.isPresent()) {
                this.getLogger().info("Register Vault Economy.");
            } else {
                this.getLogger().severe("Impossible to register Vault Economy.");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void onDisable() {
        if (this.storageManager != null) {
            this.storageManager.onDisable();
        }
        if (this.persist != null) {
            ConfigStorage.getInstance().save(this.persist);
        }
        this.essentialsServer.onDisable();
    }

    private void registerButtons() {
        this.buttonManager.register((ButtonLoader)new NoneLoader((Plugin)this, ButtonTeleportationConfirmHere.class, "ZESSENTIALS_TELEPORTATION_CONFIRM_HERE"));
        this.buttonManager.register((ButtonLoader)new NoneLoader((Plugin)this, ButtonTeleportationConfirm.class, "ZESSENTIALS_TELEPORTATION_CONFIRM"));
        this.buttonManager.register((ButtonLoader)new NoneLoader((Plugin)this, ButtonPayConfirm.class, "ZESSENTIALS_PAY_CONFIRM"));
        this.buttonManager.register((ButtonLoader)new NoneLoader((Plugin)this, ButtonHomes.class, "ZESSENTIALS_HOMES"));
        this.buttonManager.register((ButtonLoader)new NoneLoader((Plugin)this, ButtonSanctionInformation.class, "ZESSENTIALS_SANCTION_INFORMATION"));
        this.buttonManager.register((ButtonLoader)new NoneLoader((Plugin)this, ButtonSanctions.class, "ZESSENTIALS_SANCTIONS"));
        this.buttonManager.register((ButtonLoader)new NoneLoader((Plugin)this, ButtonKitPreview.class, "ZESSENTIALS_KIT_PREVIEW"));
        this.buttonManager.register((ButtonLoader)new NoneLoader((Plugin)this, ButtonMailBox.class, "ZESSENTIALS_MAILBOX"));
        this.buttonManager.register((ButtonLoader)new NoneLoader((Plugin)this, ButtonMailBoxAdmin.class, "ZESSENTIALS_MAILBOX_ADMIN"));
        this.buttonManager.register((ButtonLoader)new NoneLoader((Plugin)this, ButtonVaultSlotDisable.class, "ZESSENTIALS_VAULT_SLOTS_DISABLE"));
        this.buttonManager.register((ButtonLoader)new NoneLoader((Plugin)this, ButtonVaultSlotItems.class, "ZESSENTIALS_VAULT_SLOTS_ITEMS"));
        this.buttonManager.register((ButtonLoader)new NoneLoader((Plugin)this, ButtonVaultIcon.class, "ZESSENTIALS_VAULT_CHANGE_ICON"));
        this.buttonManager.register((ButtonLoader)new NoneLoader((Plugin)this, ButtonVaultRename.class, "ZESSENTIALS_VAULT_CHANGE_NAME"));
        this.buttonManager.register((ButtonLoader)new ButtonWarpLoader(this));
        this.buttonManager.register((ButtonLoader)new ButtonSanctionLoader(this));
        this.buttonManager.register((ButtonLoader)new ButtonKitCooldownLoader(this));
        this.buttonManager.register((ButtonLoader)new ButtonKitGetLoader(this));
        this.buttonManager.register((ButtonLoader)new ButtonVaultOpenLoader(this));
        this.buttonManager.register((ButtonLoader)new ButtonVaultNoPermissionLoader(this));
        this.buttonManager.register((ButtonLoader)new ButtonOptionLoader(this));
    }

    @Override
    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    @Override
    public List<ConfigurationFile> getConfigurationFiles() {
        return this.configurationFiles;
    }

    @Override
    public Gson getGson() {
        return this.gson;
    }

    @Override
    public Persist getPersist() {
        return this.persist;
    }

    @Override
    public PlatformScheduler getScheduler() {
        return this.platformScheduler;
    }

    @Override
    public ModuleManager getModuleManager() {
        return this.moduleManager;
    }

    @Override
    public InventoryManager getInventoryManager() {
        return this.inventoryManager;
    }

    @Override
    public ButtonManager getButtonManager() {
        return this.buttonManager;
    }

    @Override
    public PatternManager getPatternManager() {
        return this.patternManager;
    }

    @Override
    public Placeholder getPlaceholder() {
        return this.placeholder;
    }

    @Override
    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    private GsonBuilder getGsonBuilder() {
        return new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().serializeNulls().excludeFieldsWithModifiers(new int[]{128, 64}).registerTypeAdapter(SafeLocation.class, (Object)new LocationAdapter(this)).registerTypeAdapter(User.class, (Object)new UserTypeAdapter(this)).registerTypeAdapter(ZUser.class, (Object)new UserTypeAdapter(this));
    }

    private <T extends PlaceholderRegister> T registerPlaceholder(Class<T> placeholderClass) {
        try {
            PlaceholderRegister placeholderRegister = (PlaceholderRegister)placeholderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            placeholderRegister.register(this.placeholder, this);
            return (T)placeholderRegister;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean isEconomyEnable() {
        return this.economyManager.isEnable();
    }

    @Override
    public EconomyManager getEconomyManager() {
        return this.economyManager;
    }

    @Override
    public UUID getConsoleUniqueId() {
        return this.consoleUniqueId;
    }

    private void generateDocs() {
        CommandMarkdownGenerator commandMarkdownGenerator = new CommandMarkdownGenerator();
        PlaceholderMarkdownGenerator placeholderMarkdownGenerator = new PlaceholderMarkdownGenerator();
        PermissionMarkdownGenerator permissionMarkdownGenerator = new PermissionMarkdownGenerator();
        File folder = new File(this.getDataFolder(), "docs");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File fileCommand = new File(folder, "commands.md");
        File filePlaceholder = new File(folder, "placeholders.md");
        File filePermissions = new File(folder, "permissions.md");
        try {
            commandMarkdownGenerator.generateMarkdownFile(this.commandManager.getSortCommands(), fileCommand.toPath());
            this.getLogger().info("Markdown 'commands.md' file successfully generated!");
        }
        catch (IOException exception) {
            this.getLogger().severe("Error while writing the file commands: " + exception.getMessage());
            exception.printStackTrace();
        }
        try {
            placeholderMarkdownGenerator.generateMarkdownFile(((LocalPlaceholder)this.placeholder).getAutoPlaceholders(), filePlaceholder.toPath());
            this.getLogger().info("Markdown 'placeholders.md' file successfully generated!");
        }
        catch (IOException exception) {
            this.getLogger().severe("Error while writing the file placeholders: " + exception.getMessage());
            exception.printStackTrace();
        }
        try {
            ArrayList<PermissionInfo> permissions = new ArrayList<PermissionInfo>();
            List<EssentialsCommand> commands = this.commandManager.getCommands();
            for (Permission permission : Permission.values()) {
                EssentialsCommand command;
                Optional<EssentialsCommand> optional = commands.stream().filter(essentialsCommand -> essentialsCommand.getPermission() != null && essentialsCommand.getPermission().equals(permission.asPermission())).findFirst();
                String description = permission.getDescription();
                if (optional.isPresent() && (command = optional.get()).getDescription() != null) {
                    description = command.getDescription();
                }
                permissions.add(new PermissionInfo(permission.toPermission(), description));
            }
            permissionMarkdownGenerator.generateMarkdownFile(permissions, filePermissions.toPath());
            this.getLogger().info("Markdown 'permissions.md' file successfully generated!");
        }
        catch (IOException exception) {
            this.getLogger().severe("Error while writing the file permissions: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    @Override
    public ServerStorage getServerStorage() {
        return this.serverStorage;
    }

    @Override
    public void setServerStorage(ServerStorage serverStorage) {
        this.serverStorage = serverStorage;
    }

    @Override
    public boolean isFolia() {
        return this.platformScheduler instanceof FoliaImplementation;
    }

    @Override
    public List<Warp> getWarps() {
        return ConfigStorage.warps;
    }

    @Override
    public Optional<Warp> getWarp(String name) {
        return this.getWarps().stream().filter(warp -> warp.name().equalsIgnoreCase(name)).findFirst();
    }

    @Override
    public int getMaxHome(Permissible permissible) {
        return this.moduleManager.getModule(HomeModule.class).getMaxHome(permissible);
    }

    @Override
    public User getUser(UUID uniqueId) {
        return this.storageManager.getStorage().getUser(uniqueId);
    }

    @Override
    public EssentialsServer getEssentialsServer() {
        return this.essentialsServer;
    }

    @Override
    public EssentialsUtils getUtils() {
        return this.essentialsUtils;
    }

    @Override
    public void debug(String string) {
        if (this.configuration != null && this.configuration.isEnableDebug()) {
            this.getLogger().info(string);
        }
    }

    @Override
    public void openInventory(Player player, String inventoryName) {
        this.inventoryManager.getInventory((Plugin)this, inventoryName).ifPresent(inventory -> this.platformScheduler.runAtLocation(player.getLocation(), wrappedTask -> this.inventoryManager.getCurrentPlayerInventory(player).ifPresentOrElse(oldInventory -> this.inventoryManager.openInventory(player, inventory, 1, new Inventory[]{oldInventory}), () -> this.inventoryManager.openInventory(player, inventory))));
    }

    @Override
    public void saveOrUpdateConfiguration(String resourcePath, boolean deep) {
        this.saveOrUpdateConfiguration(resourcePath, resourcePath, deep);
    }

    @Override
    public void saveOrUpdateConfiguration(String resourcePath, String toPath, boolean deep) {
        File file = new File(this.getDataFolder(), toPath);
        if (!file.exists()) {
            this.saveResource(resourcePath, toPath, false);
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        try {
            InputStream inputStream = this.getResource(resourcePath);
            if (inputStream == null) {
                this.getLogger().severe("Cannot find file " + resourcePath);
                return;
            }
            InputStreamReader defConfigStream = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)defConfigStream);
            Set defaultKeys = defConfig.getKeys(deep);
            boolean configUpdated = false;
            for (String key : defaultKeys) {
                if (config.contains(key)) continue;
                this.debug("I can\u2019t find " + key + " in the file " + file.getName());
                configUpdated = true;
            }
            config.setDefaults((org.bukkit.configuration.Configuration)defConfig);
            config.options().copyDefaults(true);
            if (configUpdated) {
                this.getLogger().info("Update file " + toPath);
                config.save(file);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public Optional<Kit> getKit(String kitName) {
        return this.moduleManager.getModule(KitModule.class).getKit(kitName);
    }

    @Override
    public void giveKit(User user, Kit kit, boolean bypassCooldown) {
        this.moduleManager.getModule(KitModule.class).giveKit(user, kit, bypassCooldown);
    }

    @Override
    public List<Material> getMaterials() {
        return this.materials;
    }

    @Override
    public ScoreboardManager getScoreboardManager() {
        return this.scoreboardManager;
    }

    @Override
    public void give(OfflinePlayer offlinePlayer, ItemStack itemStack) {
        if (offlinePlayer.isOnline()) {
            this.give(Objects.requireNonNull(offlinePlayer.getPlayer()), itemStack);
        } else {
            MailBoxModule mailBoxModule = this.moduleManager.getModule(MailBoxModule.class);
            if (!mailBoxModule.isEnable()) {
                Location location = offlinePlayer.getLocation();
                if (location == null) {
                    return;
                }
                location.getWorld().dropItemNaturally(location, itemStack);
                return;
            }
            mailBoxModule.addItemAndFix(offlinePlayer.getUniqueId(), itemStack);
        }
    }

    @Override
    public void give(Player player, ItemStack itemStack) {
        PlayerInventory inventory = player.getInventory();
        HashMap result = inventory.addItem(new ItemStack[]{itemStack});
        if (result.isEmpty()) {
            return;
        }
        MailBoxModule mailBoxModule = this.moduleManager.getModule(MailBoxModule.class);
        if (!mailBoxModule.isEnable()) {
            result.values().forEach(item -> player.getWorld().dropItemNaturally(player.getLocation(), item));
            return;
        }
        result.values().forEach(item -> mailBoxModule.addItemAndFix(player.getUniqueId(), (ItemStack)item));
    }

    @Override
    public HologramManager getHologramManager() {
        return this.hologramManager;
    }

    @Override
    public ComponentMessage getComponentMessage() {
        return ComponentMessageHelper.componentMessage;
    }

    @Override
    public String papi(Player player, String string) {
        return PlaceholderUtils.PapiHelper.papi(string, player);
    }

    @Override
    public <T> Optional<T> createInstance(String className) {
        try {
            Class<?> clazz = Class.forName("fr.maxlego08.essentials.hooks." + className);
            try {
                Constructor<?> constructor = clazz.getConstructor(EssentialsPlugin.class);
                return Optional.of(constructor.newInstance(this));
            }
            catch (NoSuchMethodException error) {
                return Optional.of(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (Exception exception) {
            this.getLogger().severe("Cannot create a new instance for the class " + className);
            this.getLogger().severe(exception.getMessage());
            return Optional.empty();
        }
    }

    @Override
    public VoteManager getVoteManager() {
        return this.moduleManager.getModule(VoteModule.class);
    }

    @Override
    public VaultManager getVaultManager() {
        return this.moduleManager.getModule(VaultModule.class);
    }

    @Override
    public WorldeditManager getWorldeditManager() {
        return this.moduleManager.getModule(WorldeditModule.class);
    }

    @Override
    public InteractiveChat startInteractiveChat(Player player, Consumer<String> consumer, long expiredAt) {
        InteractiveChat interactiveChat = new InteractiveChat(consumer, expiredAt);
        this.interactiveChatHelper.register(player, interactiveChat);
        return interactiveChat;
    }

    @Override
    public Enchantments getEnchantments() {
        return this.enchantments;
    }

    @Override
    public long getServerStartupTime() {
        return this.serverStartUptime;
    }

    @Override
    public RandomWord getRandomWord() {
        return this.randomWord;
    }

    @Override
    public BlockTracker getBlockTracker() {
        return this.blockTracker;
    }

    @Override
    public void setBlockTracker(BlockTracker blockTracker) {
        this.blockTracker = blockTracker;
    }

    @Override
    public List<PermissionChecker> getPermissions() {
        return this.permissionCheckers;
    }

    @Override
    public void addMailBoxItem(UUID uuid, ItemStack itemStack) {
        this.getModuleManager().getModule(MailBoxModule.class).addItem(uuid, itemStack);
    }

    @Override
    public StepManager getStepManager() {
        return this.getModuleManager().getModule(StepModule.class);
    }

    @Override
    public AfkManager getAfkManager() {
        return this.getModuleManager().getModule(AFKModule.class);
    }

    @Override
    public DiscordManager getDiscordManager() {
        return this.getModuleManager().getModule(DiscordModule.class);
    }

    @Override
    public HomeManager getHomeManager() {
        return this.getModuleManager().getModule(HomeModule.class);
    }

    @Override
    public SanctionManager getSanctionManager() {
        return this.getModuleManager().getModule(SanctionModule.class);
    }

    @Override
    public WayPointHelper getWayPointHelper() {
        if (this.wayPointHelper == null) {
            String version = NmsVersion.getCurrentVersion().name().replace("V_", "v");
            String className = String.format("fr.maxlego08.essentials.nms.%s.WayPointPacket", version);
            try {
                Class<?> clazz = Class.forName(className);
                this.wayPointHelper = (WayPointHelper)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                this.getLogger().severe("Cannot create a new instance for the class " + className);
                this.getLogger().severe(exception.getMessage());
            }
        }
        return this.wayPointHelper;
    }

    private void loadHooks() {
        if (this.getServer().getPluginManager().isPluginEnabled("BlockTracker")) {
            this.createInstance("BlockTrackerHook").ifPresent(object -> {
                this.blockTracker = (BlockTracker)object;
                this.getLogger().info("Register BlockTracker.");
            });
        }
        if (this.getServer().getPluginManager().isPluginEnabled("SuperiorSkyBlock2")) {
            this.createInstance("SuperiorSkyBlockPermission").ifPresent(object -> {
                this.permissionCheckers.add((PermissionChecker)object);
                this.getLogger().info("Register SuperiorSkyBlock Permission Checker.");
            });
        }
        if (this.getServer().getPluginManager().getPlugin("WorldGuard") != null) {
            this.createInstance("WorldGuardBlockPermission").ifPresent(object -> {
                this.permissionCheckers.add((PermissionChecker)object);
                this.getLogger().info("Register WorldGuard Permission Checker.");
            });
        }
        if (this.getServer().getPluginManager().isPluginEnabled("Votifier")) {
            this.createInstance("NuVotifierHook").ifPresent(object -> this.getLogger().info("Register NuVotifierHook."));
        }
        if (this.getServer().getPluginManager().isPluginEnabled("NChat")) {
            this.createInstance("NChatHook").ifPresent(object -> this.getLogger().info("Register NChatHook."));
        }
    }
}

