/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.api.cache;

import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;

public class ExpiringCache<K, V> {
    private final ConcurrentHashMap<K, CacheEntry<V>> cache = new ConcurrentHashMap();
    private final long expiryDurationMillis;

    public ExpiringCache(long expiryDurationMillis) {
        this.expiryDurationMillis = expiryDurationMillis;
    }

    public V get(K key, Loader<V> loader) {
        return this.cache.compute(key, (BiFunction<Object, CacheEntry, CacheEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$get$0(fr.maxlego08.essentials.api.cache.ExpiringCache$Loader java.lang.Object fr.maxlego08.essentials.api.cache.ExpiringCache$CacheEntry ), (Ljava/lang/Object;Lfr/maxlego08/essentials/api/cache/ExpiringCache$CacheEntry;)Lfr/maxlego08/essentials/api/cache/ExpiringCache$CacheEntry;)((ExpiringCache)this, loader)).value;
    }

    public void clear(K key) {
        this.cache.remove(key);
    }

    private /* synthetic */ CacheEntry lambda$get$0(Loader loader, Object k, CacheEntry v) {
        long currentTime = System.currentTimeMillis();
        if (v == null || v.expiryTime < currentTime) {
            Object newValue = loader.load();
            return new CacheEntry(newValue, currentTime + this.expiryDurationMillis);
        }
        return v;
    }

    @FunctionalInterface
    public static interface Loader<V> {
        public V load();
    }

    private record CacheEntry<V>(V value, long expiryTime) {
    }
}

