/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.api.hologram;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.hologram.ComponentCache;
import fr.maxlego08.essentials.api.hologram.HologramLine;
import fr.maxlego08.essentials.api.hologram.HologramType;
import fr.maxlego08.essentials.api.hologram.configuration.HologramConfiguration;
import fr.maxlego08.essentials.api.utils.SafeLocation;
import fr.maxlego08.essentials.api.utils.component.AdventureComponent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public abstract class Hologram {
    public static final int LINE_WIDTH = 1200;
    public static final TextColor TRANSPARENT = () -> 0;
    protected final EssentialsPlugin plugin;
    protected final HologramType hologramType;
    protected final String name;
    protected final String fileName;
    protected final List<HologramLine> hologramLines = new ArrayList<HologramLine>();
    protected final Map<Player, ComponentCache> caches = new HashMap<Player, ComponentCache>();
    protected final HologramConfiguration configuration;
    protected SafeLocation location;
    private boolean isLoaded = false;

    public Hologram(EssentialsPlugin plugin, HologramType hologramType, String name, String fileName, SafeLocation location, HologramConfiguration configuration) {
        this.plugin = plugin;
        this.hologramType = hologramType;
        this.name = name;
        this.fileName = fileName;
        this.location = location;
        this.configuration = configuration;
    }

    public abstract void create(Player var1);

    public abstract void delete(Player var1);

    public abstract void update(Player var1);

    public abstract void update();

    public abstract void create();

    public abstract void updateLocation();

    public String getFileName() {
        return this.fileName;
    }

    public SafeLocation getLocation() {
        return this.location;
    }

    public List<HologramLine> getHologramLines() {
        return this.hologramLines;
    }

    public String getName() {
        return this.name;
    }

    public void addLine(HologramLine hologramLine) {
        this.hologramLines.add(hologramLine);
    }

    public int getNextIndex() {
        return this.hologramLines.size() + 1;
    }

    public EssentialsPlugin getPlugin() {
        return this.plugin;
    }

    public HologramType getHologramType() {
        return this.hologramType;
    }

    public HologramConfiguration getConfiguration() {
        return this.configuration;
    }

    public void createForAllPlayers() {
        Bukkit.getOnlinePlayers().forEach(player -> {
            if (player.getWorld().getName().equals(this.getLocation().getWorld())) {
                this.create((Player)player);
            }
        });
    }

    public void deleteForAllPlayers() {
        Bukkit.getOnlinePlayers().forEach(this::delete);
    }

    public void updateForAllPlayers() {
        this.caches.clear();
        Bukkit.getOnlinePlayers().forEach(this::update);
    }

    public Map<Player, ComponentCache> getCaches() {
        return this.caches;
    }

    public void removePlayer(Player player) {
        this.caches.remove(player);
    }

    public Component getComponentText(Player player) {
        AdventureComponent componentMessage = (AdventureComponent)this.plugin.getComponentMessage();
        ComponentCache componentCache = this.caches.computeIfAbsent(player, k -> new ComponentCache());
        if (componentCache.isEmpty()) {
            List<Component> components = this.hologramLines.stream().sorted(Comparator.comparingInt(HologramLine::getLine)).map(HologramLine::getText).map(line -> this.plugin.papi(player, (String)line)).map(componentMessage::getComponent).toList();
            componentCache.setComponents(components);
        }
        return componentCache.merge();
    }

    public Optional<HologramLine> getHologramLine(int line) {
        return this.hologramLines.stream().filter(hologramLine -> hologramLine.getLine() == line).findFirst();
    }

    public void removeLine(int line) {
        this.hologramLines.removeIf(hologramLine -> hologramLine.getLine() == line);
        for (HologramLine hologramLine2 : this.hologramLines) {
            if (hologramLine2.getLine() <= line) continue;
            hologramLine2.setLine(hologramLine2.getLine() - 1);
        }
    }

    public void teleport(Location location) {
        this.location = new SafeLocation(location);
        this.updateLocation();
    }

    public void insertLineBefore(int line, HologramLine newLine) {
        for (HologramLine hologramLine : this.hologramLines) {
            if (hologramLine.getLine() < line) continue;
            hologramLine.setLine(hologramLine.getLine() + 1);
        }
        newLine.setLine(line);
        this.hologramLines.add(newLine);
        this.hologramLines.sort(Comparator.comparingInt(HologramLine::getLine));
    }

    public void insertAfterLine(int line, HologramLine newLine) {
        for (HologramLine hologramLine : this.hologramLines) {
            if (hologramLine.getLine() <= line) continue;
            hologramLine.setLine(hologramLine.getLine() + 1);
        }
        newLine.setLine(line + 1);
        this.hologramLines.add(newLine);
        this.hologramLines.sort(Comparator.comparingInt(HologramLine::getLine));
    }

    public void updateLines(Player player, String eventName) {
        AdventureComponent componentMessage = (AdventureComponent)this.plugin.getComponentMessage();
        ComponentCache componentCache = this.caches.computeIfAbsent(player, k -> new ComponentCache());
        List<HologramLine> hologramLines = this.hologramLines.stream().filter(hologramLine -> hologramLine.getEventName() != null && hologramLine.getEventName().equalsIgnoreCase(eventName)).toList();
        hologramLines.forEach(hologramLine -> componentCache.updateComponent(hologramLine.getLine() - 1, componentMessage.getComponent(this.plugin.papi(player, hologramLine.getText()))));
        this.update(player);
    }

    public void autoUpdateLines(Player player) {
        AdventureComponent componentMessage = (AdventureComponent)this.plugin.getComponentMessage();
        ComponentCache componentCache = this.caches.computeIfAbsent(player, k -> new ComponentCache());
        List<HologramLine> hologramLines = this.hologramLines.stream().filter(HologramLine::isAutoUpdate).toList();
        hologramLines.forEach(hologramLine -> componentCache.updateComponent(hologramLine.getLine() - 1, componentMessage.getComponent(this.plugin.papi(player, hologramLine.getText()))));
        this.update(player);
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void setLoaded(boolean loaded) {
        this.isLoaded = loaded;
    }

    public boolean canLoad() {
        return Bukkit.getWorld((String)this.location.getWorld()) != null;
    }
}

