/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.api.messages;

import fr.maxlego08.essentials.api.messages.DefaultFontInfo;
import java.util.Random;

public class MessageHelper {
    private static final String CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";

    public static int getStringLength(String message) {
        int messagePxSize = 0;
        boolean previousCode = false;
        boolean isBold = false;
        for (char c : message.toCharArray()) {
            if (c == '\u00a7') {
                previousCode = true;
                continue;
            }
            if (previousCode) {
                previousCode = false;
                isBold = c == 'l' || c == 'L';
                continue;
            }
            DefaultFontInfo dFI = DefaultFontInfo.getDefaultFontInfo(c);
            messagePxSize += isBold ? dFI.getBoldLength() : dFI.getLength();
            ++messagePxSize;
        }
        return messagePxSize;
    }

    public static String removeColorCodes(String input) {
        input = input.replaceAll("#[0-9a-fA-F]{6}", "");
        input = input.replaceAll("\u00a7[0-9a-fA-Fk-oK-OrR]", "");
        return input.replaceAll("&[0-9a-fA-Fk-oK-OrR]", "");
    }

    public static String getFormattedString(String start, String end, int size) {
        int endSize;
        int startSize = MessageHelper.getStringLength(MessageHelper.removeColorCodes(start));
        int needSize = size - startSize - (endSize = MessageHelper.getStringLength(MessageHelper.removeColorCodes(end)));
        if (needSize <= 0) {
            return start + end;
        }
        Object diff = " ";
        while (MessageHelper.getStringLength((String)diff) < needSize) {
            diff = (String)diff + ".";
        }
        return start + (String)diff + end;
    }

    public static String generateRandomPseudo() {
        Random random = new Random();
        int length = 3 + random.nextInt(14);
        StringBuilder pseudo = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            pseudo.append(CHARACTERS.charAt(random.nextInt(CHARACTERS.length())));
        }
        return pseudo.toString();
    }
}

