/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.api.scoreboard;

import fr.maxlego08.essentials.api.scoreboard.PlayerBoard;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;

public abstract class ScoreboardAnimation {
    protected static final ScheduledExecutorService EXECUTOR_SERVICE = Executors.newSingleThreadScheduledExecutor();
    protected final PlayerBoard playerBoard;
    protected ScheduledFuture<?> future = null;
    protected final int line;

    public ScoreboardAnimation(PlayerBoard playerBoard, int line) {
        this.playerBoard = playerBoard;
        this.line = line;
    }

    public abstract void start();

    protected String blendColors(String baseColorHex, String highlightColorHex, int currentIndex, int highlightIndex, int textLength) {
        int baseColor = Integer.parseInt(baseColorHex.substring(1), 16);
        int highlightColor = Integer.parseInt(highlightColorHex.substring(1), 16);
        float ratio = (float)Math.abs(currentIndex - highlightIndex) / (float)textLength;
        int rBase = baseColor >> 16 & 0xFF;
        int gBase = baseColor >> 8 & 0xFF;
        int bBase = baseColor & 0xFF;
        int rHighlight = highlightColor >> 16 & 0xFF;
        int gHighlight = highlightColor >> 8 & 0xFF;
        int bHighlight = highlightColor & 0xFF;
        int r = (int)((float)rBase + ratio * (float)(rHighlight - rBase));
        int g = (int)((float)gBase + ratio * (float)(gHighlight - gBase));
        int b = (int)((float)bBase + ratio * (float)(bHighlight - bBase));
        return String.format("#%02x%02x%02x", r, g, b);
    }

    public int getLine() {
        return this.line;
    }
}

