/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.api.vote;

import fr.maxlego08.essentials.api.dto.UserVoteDTO;
import fr.maxlego08.essentials.libs.folialib.wrapper.task.WrappedTask;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class VoteCache {
    private final Map<UUID, UserVoteDTO> voteMap = new ConcurrentHashMap<UUID, UserVoteDTO>();
    private final Map<UUID, Long> lastUpdateMap = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, WrappedTask> tasks = new ConcurrentHashMap<UUID, WrappedTask>();

    public synchronized void addVote(UUID uniqueId, boolean isOnline) {
        UserVoteDTO voteDTO = this.voteMap.getOrDefault(uniqueId, new UserVoteDTO(uniqueId, 0L, 0L));
        voteDTO = new UserVoteDTO(uniqueId, voteDTO.vote() + 1L, isOnline ? 0L : voteDTO.vote_offline() + 1L);
        this.voteMap.put(uniqueId, voteDTO);
        this.lastUpdateMap.put(uniqueId, System.currentTimeMillis());
    }

    public synchronized void addTask(UUID uniqueId, WrappedTask wrappedTask) {
        this.tasks.put(uniqueId, wrappedTask);
    }

    public boolean hasTask(UUID uuid) {
        return this.tasks.containsKey(uuid);
    }

    public synchronized UserVoteDTO clearVote(UUID uniqueId) {
        this.lastUpdateMap.remove(uniqueId);
        this.tasks.remove(uniqueId);
        return this.voteMap.remove(uniqueId);
    }

    public long getLastUpdateTimestamp(UUID uniqueId) {
        return this.lastUpdateMap.getOrDefault(uniqueId, 0L);
    }
}

