/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.buttons.kit;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.kit.Kit;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.zutils.utils.TimerBuilder;
import fr.maxlego08.menu.api.button.Button;
import fr.maxlego08.menu.api.engine.InventoryEngine;
import fr.maxlego08.menu.api.utils.Placeholders;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;

public class ButtonKitGet
extends Button {
    private final EssentialsPlugin plugin;
    private final String kitName;

    public ButtonKitGet(EssentialsPlugin plugin, String kitName) {
        this.plugin = plugin;
        this.kitName = kitName;
    }

    public void onClick(Player player, InventoryClickEvent event, InventoryEngine inventory, int slot, Placeholders placeholders) {
        User user = this.plugin.getUser(player.getUniqueId());
        if (user == null) {
            return;
        }
        Optional<Kit> optional = this.plugin.getKit(this.kitName);
        if (optional.isEmpty()) {
            return;
        }
        Kit kit = optional.get();
        if (event.getClick().isLeftClick()) {
            this.plugin.giveKit(user, kit, false);
        } else if (event.getClick().isRightClick()) {
            user.openKitPreview(kit);
            return;
        }
        super.onClick(player, event, inventory, slot, placeholders);
    }

    public ItemStack getCustomItemStack(Player player) {
        Placeholders placeholders = new Placeholders();
        Optional<Kit> optional = this.plugin.getKit(this.kitName);
        if (optional.isEmpty()) {
            return super.getCustomItemStack(player);
        }
        Kit kit = optional.get();
        placeholders.register("cooldown", TimerBuilder.getStringTime(kit.getCooldown() * 1000L));
        return this.getItemStack().build(player, false, placeholders);
    }

    public boolean hasPermission() {
        return true;
    }

    public boolean checkPermission(Player player, InventoryEngine inventory, Placeholders placeholders) {
        User user = this.plugin.getUser(player.getUniqueId());
        if (user == null) {
            return false;
        }
        Optional<Kit> optional = this.plugin.getKit(this.kitName);
        return optional.filter(kit -> super.checkPermission(player, inventory, placeholders) && kit.hasPermission((Permissible)player)).isPresent();
    }
}

