/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.buttons.mail;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.mailbox.MailBoxItem;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.buttons.mail.ButtonMailBoxHelper;
import fr.maxlego08.menu.api.engine.InventoryEngine;
import fr.maxlego08.menu.api.utils.Placeholders;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ButtonMailBoxAdmin
extends ButtonMailBoxHelper {
    private final EssentialsPlugin plugin;

    public ButtonMailBoxAdmin(Plugin plugin) {
        super((EssentialsPlugin)plugin);
        this.plugin = (EssentialsPlugin)plugin;
    }

    public boolean hasSpecialRender() {
        return true;
    }

    public void onRender(Player player, InventoryEngine inventory) {
        User user = this.plugin.getUser(player.getUniqueId());
        if (user == null) {
            return;
        }
        User targetUser = user.getTargetUser();
        if (targetUser == null) {
            return;
        }
        List<MailBoxItem> mailBoxItems = this.getMailBox(player);
        this.paginate(mailBoxItems, inventory, (slot, mailBoxItem) -> this.displayItem((int)slot, (MailBoxItem)mailBoxItem, player, user, inventory));
    }

    public boolean hasPermission() {
        return true;
    }

    public boolean checkPermission(Player player, InventoryEngine inventory, Placeholders placeholders) {
        return !this.getMailBox(player).isEmpty();
    }

    public int getPaginationSize(Player player) {
        return this.getMailBox(player).size();
    }

    private List<MailBoxItem> getMailBox(Player player) {
        User user = this.plugin.getUser(player.getUniqueId());
        if (user == null) {
            return new ArrayList<MailBoxItem>();
        }
        User targetUser = user.getTargetUser();
        if (targetUser == null) {
            return new ArrayList<MailBoxItem>();
        }
        return targetUser.getMailBoxItems();
    }
}

