/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.buttons.vault;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.vault.PlayerVaults;
import fr.maxlego08.essentials.api.vault.Vault;
import fr.maxlego08.essentials.api.vault.VaultManager;
import fr.maxlego08.menu.api.MenuItemStack;
import fr.maxlego08.menu.api.button.Button;
import fr.maxlego08.menu.api.engine.InventoryEngine;
import fr.maxlego08.menu.api.utils.Placeholders;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ButtonVaultOpen
extends Button {
    private final EssentialsPlugin plugin;
    private final int vaultId;

    public ButtonVaultOpen(Plugin plugin, int vaultId) {
        this.plugin = (EssentialsPlugin)plugin;
        this.vaultId = vaultId;
    }

    public ItemStack getCustomItemStack(Player player) {
        String icon;
        PlayerVaults playerVaults = this.plugin.getVaultManager().getPlayerVaults((OfflinePlayer)player);
        Vault targetVault = playerVaults.getTargetVault();
        Vault vault = playerVaults.getVault(this.vaultId);
        MenuItemStack itemstack = this.getItemStack();
        Placeholders placeholders = new Placeholders();
        VaultManager vaultManager = this.plugin.getVaultManager();
        ItemStack vaultItemStack = vault.getIconItemStack();
        String string = vaultItemStack != null ? vaultItemStack.getType().name() : (icon = targetVault.getVaultId() == this.vaultId ? vaultManager.getIconOpen() : vaultManager.getIconClose());
        int modelId = vaultItemStack != null && vaultItemStack.hasItemMeta() && vaultItemStack.getItemMeta().hasCustomModelData() ? vaultItemStack.getItemMeta().getCustomModelData() : (targetVault.getVaultId() == this.vaultId ? vaultManager.getIconOpenModelId() : vaultManager.getIconCloseModelId());
        placeholders.register("vault-icon", icon);
        placeholders.register("vault-model-id", String.valueOf(modelId));
        placeholders.register("vault-name", vault.getName());
        placeholders.register("vault-id", String.valueOf(this.vaultId));
        return itemstack.build(player, false, placeholders);
    }

    public void onLeftClick(Player player, InventoryClickEvent event, InventoryEngine inventory, int slot) {
        super.onLeftClick(player, event, inventory, slot);
        PlayerVaults playerVaults = this.plugin.getVaultManager().getPlayerVaults((OfflinePlayer)player);
        Vault vault = playerVaults.getTargetVault();
        if (vault == null || vault.getVaultId() == this.vaultId) {
            return;
        }
        this.plugin.getVaultManager().openVault(player, this.vaultId);
    }

    public void onRightClick(Player player, InventoryClickEvent event, InventoryEngine inventory, int slot) {
        super.onRightClick(player, event, inventory, slot);
        this.plugin.getVaultManager().openConfiguration(player, this.vaultId);
    }

    public boolean hasPermission() {
        return true;
    }

    public boolean checkPermission(Player player, InventoryEngine inventory, Placeholders placeholders) {
        return this.plugin.getVaultManager().hasPermission(player.getUniqueId(), this.vaultId);
    }
}

