/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.essentials;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.storage.IStorage;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;

public class CommandEssentialsDeleteWorld
extends VCommand {
    public CommandEssentialsDeleteWorld(EssentialsPlugin plugin) {
        super(plugin);
        this.addSubCommand("delete-world");
        this.setPermission(Permission.ESSENTIALS_DELETE_WORLD);
        this.setDescription(Message.DESCRIPTION_DELETE_WORLD);
        this.addOptionalArg("world", (a, b) -> Bukkit.getWorlds().stream().map(WorldInfo::getName).toList());
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        String worldName = this.argAsString(0);
        if (this.sender instanceof Player) {
            this.message(this.sender, "&cOnly the console can run this command!");
            return CommandResultType.DEFAULT;
        }
        if (Bukkit.getOnlinePlayers().size() != 0) {
            this.message(this.sender, "&cThere must be no players connected to execute this command!");
            return CommandResultType.DEFAULT;
        }
        this.message(this.sender, "&aStart of deletion of &f" + worldName + "&c world related data.");
        IStorage storage = plugin.getStorageManager().getStorage();
        storage.deleteWorldData(worldName);
        this.message(this.sender, "&f" + worldName + "&a world data has been deleted!");
        return CommandResultType.SUCCESS;
    }
}

