/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.fly;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.commands.commands.fly.CommandFlyAdd;
import fr.maxlego08.essentials.commands.commands.fly.CommandFlyGet;
import fr.maxlego08.essentials.commands.commands.fly.CommandFlyInfo;
import fr.maxlego08.essentials.commands.commands.fly.CommandFlyRemove;
import fr.maxlego08.essentials.commands.commands.fly.CommandFlySet;
import fr.maxlego08.essentials.zutils.utils.TimerBuilder;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class CommandFly
extends VCommand {
    public CommandFly(EssentialsPlugin plugin) {
        super(plugin);
        this.setPermission(Permission.ESSENTIALS_FLY);
        this.setDescription(Message.DESCRIPTION_FLY);
        this.addSubCommand(new CommandFlyAdd(plugin));
        this.addSubCommand(new CommandFlyRemove(plugin));
        this.addSubCommand(new CommandFlySet(plugin));
        this.addSubCommand(new CommandFlyInfo(plugin));
        this.addSubCommand(new CommandFlyGet(plugin));
        this.addOptionalArg("player");
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        Player player = this.argAsPlayer(0, this.player);
        if (player == null) {
            return CommandResultType.SYNTAX_ERROR;
        }
        if (!this.hasPermission((Permissible)this.sender, Permission.ESSENTIALS_FLY_OTHER)) {
            player = this.player;
        }
        if (plugin.getConfiguration().getDisableFlyWorld().contains(player.getWorld().getName()) && !this.hasPermission((Permissible)player, Permission.ESSENTIALS_FLY_BYPASS_WORLD)) {
            this.message(this.sender, Message.COMMAND_FLY_ERROR_WORLD, new Object[0]);
            return CommandResultType.DEFAULT;
        }
        if (this.hasPermission((Permissible)this.sender, Permission.ESSENTIALS_FLY_UNLIMITED)) {
            player.setAllowFlight(!player.getAllowFlight());
            player.setFlying(player.getAllowFlight());
            this.message(this.sender, player.getAllowFlight() ? Message.COMMAND_FLY_ENABLE : Message.COMMAND_FLY_DISABLE, "%player%", this.sender == player ? Message.YOU.getMessageAsString() : player.getName());
        } else {
            User user = plugin.getUser(player.getUniqueId());
            if (user == null) {
                return CommandResultType.SYNTAX_ERROR;
            }
            if (user.getFlySeconds() <= 0L) {
                this.message(this.sender, this.sender == player ? Message.COMMAND_FLY_ERROR : Message.COMMAND_FLY_ERROR_OTHER, player);
                return CommandResultType.DEFAULT;
            }
            player.setAllowFlight(!player.getAllowFlight());
            player.setFlying(player.getAllowFlight());
            this.message(this.sender, player.getAllowFlight() ? Message.COMMAND_FLY_ENABLE_SECONDS : Message.COMMAND_FLY_DISABLE, "%player%", this.sender == player ? Message.YOU.getMessageAsString() : player.getName(), "%time%", TimerBuilder.getStringTime(user.getFlySeconds() * 1000L));
        }
        return CommandResultType.SUCCESS;
    }
}

